﻿Partial Public Class MainPage
    Inherits UserControl

    Public Sub New()
        InitializeComponent()

        Dim person As New List(Of Person)
        For i = 1 To 10
            person.Add(New Person() With {.Name = "Name ID " + i.ToString,
                                          .OrderID = i,
                                          .Quantity = i * 100})
        Next

        Me.C1FlexGrid1.ItemsSource = person
        Me.C1FlexGrid1.CellFactory = New MyCellFactory()
    End Sub

End Class

Public Class MyCellFactory
    Inherits C1.Silverlight.FlexGrid.CellFactory
    Public Overrides Sub CreateCellContent(grid As C1.Silverlight.FlexGrid.C1FlexGrid, bdr As System.Windows.Controls.Border, rng As C1.Silverlight.FlexGrid.CellRange)
        MyBase.CreateCellContent(grid, bdr, rng)

        If rng.Column = 0 Then
            Dim obj = bdr.Child
            If obj.GetType() Is GetType(TextBlock) Then
                If Not CType(obj, TextBlock).Text = String.Empty Then
                    bdr.Child = Nothing
                    Dim width As Integer = 0
                    Dim height As Integer = 0
                    If CType(obj, TextBlock) IsNot Nothing Then
                        width = CType(obj, TextBlock).ActualWidth
                        height = CType(obj, TextBlock).ActualHeight
                    End If
                    Dim ln As New Line
                    ln.Stroke = New SolidColorBrush(Colors.Red)
                    ln.StrokeThickness = 1
                    ln.X1 = 0
                    ln.Y1 = (height / 2) + 3
                    ln.X2 = width + 1
                    ln.Y2 = (height / 2) + 3
                    Dim grd As New Grid
                    grd.Children.Add(ln)
                    grd.Children.Add(obj)
                    DirectCast(obj, TextBlock).Foreground = New SolidColorBrush(Colors.Green)
                    bdr.Child = grd
                End If
            End If
        End If

    End Sub
End Class

Public Class Person

#Region "Private Variables"
    Private _name As String
    Private _OrderID As Integer
    Private _Quantity As Decimal
    Private _Item0 As String
    Private _Item1 As String
    Private _Item2 As String
    Private _Item3 As String
    Private _Item4 As String
    Private _Item5 As String
#End Region
#Region "Property"
    Public Property Name As String
        Get
            Return _name
        End Get
        Set(value As String)
            _name = value
        End Set
    End Property

    Public Property OrderID() As Integer
        Get
            Return _OrderID
        End Get
        Set(ByVal value As Integer)
            If value <> _OrderID Then
                _OrderID = value
            End If
        End Set
    End Property

    Public Property Quantity As Decimal
        Get
            Return _Quantity
        End Get
        Set(value As Decimal)
            If value <> _Quantity Then
                _Quantity = value
            End If
        End Set
    End Property

#End Region

End Class