﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TDBGrid_RuntimeHierarchicalView
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        System.Data.OleDb.OleDbDataAdapter _dataAdapter;
        DataSet _dataSet;
        private void Form1_Load(object sender, EventArgs e)
        {
            this.Text = Application.ProductName;
            // ************* Modify Connection string to access database
            System.Data.OleDb.OleDbConnection myConnection = new System.Data.OleDb.OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Application.StartupPath + "\\C1Nwind.mdb;");
            //********* Open the connection
            try
            {
                myConnection.Open();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Connect-Error: " + ex.Message);
                return;
            }
            //*********** Adding tables to dataset
            _dataSet = new DataSet("myData");
            _dataSet.Tables.Add("myCustomers");
            _dataSet.Tables.Add("myOrders");

            //********** Populating tables with data
            _dataAdapter = new System.Data.OleDb.OleDbDataAdapter("Select * from Customers", myConnection);
            _dataAdapter.Fill(_dataSet.Tables["myCustomers"]);
            _dataAdapter.Dispose();

            _dataAdapter = new System.Data.OleDb.OleDbDataAdapter("Select * from Orders", myConnection);
            _dataAdapter.Fill(_dataSet.Tables["myOrders"]);
            _dataAdapter.Dispose();

            //************ Creating relation between two tables
            _dataSet.Relations.Add("Customers_Orders_rel", _dataSet.Tables["myCustomers"].Columns["CustomerID"], _dataSet.Tables["myOrders"].Columns["CustomerID"]);

            var _with1 = C1TrueDBGridMaster;
            _with1.DataSource = _dataSet;

            //**************** DataMember of MasterTable
            _with1.DataMember = "myCustomers";
            _with1.Visible = true;

            C1TrueDBGridChild.DataSource = _dataSet;
            C1TrueDBGridChild.DataMember = "myCustomers.Customers_Orders_rel";

            //************* Setting ParentTable.RelationName
            C1TrueDBGridMaster.ChildGrid = C1TrueDBGridChild;
        }
    }
}
