﻿Partial Public Class MainPage
    Inherits UserControl


    Dim _text As String

    Public Sub New()
        InitializeComponent()

        Dim list = New List(Of TestData)()
        list.Add(New TestData() With {.Name = "Jason Bourne", .Title = "Mr."})
        list.Add(New TestData() With {.Name = "Marie St.Jacques", .Title = "Mrs."})
        list.Add(New TestData() With {.Name = "Alexander Conklin", .Title = "Mr."})
        list.Add(New TestData() With {.Name = "David Webb", .Title = "Mr."})
        list.Add(New TestData() With {.Name = "Gordon Webb", .Title = "Mr."})
        list.Add(New TestData() With {.Name = "Joshua Webb", .Title = "Master"})

        Me.c1FlexGrid1.ItemsSource = list

    End Sub

    'refresh grid each time button is clicked for a new search and highlight text
    Private Sub button1_Click(sender As Object, e As System.Windows.RoutedEventArgs) Handles button1.Click

        _text = Me.textBox1.Text
        c1FlexGrid1.CellFactory = New MyCellFactory(_text)

    End Sub

    'refresh grid each time ENTER keys is pressed inside TextBox and highlight text

    Private Sub textBox1_KeyDown(sender As Object, e As System.Windows.Input.KeyEventArgs) Handles textBox1.KeyDown

        If e.Key = Key.Enter Then
            _text = Me.textBox1.Text
            c1FlexGrid1.CellFactory = New MyCellFactory(_text)
        End If

    End Sub
End Class

'Customized CellFactory
Public Class MyCellFactory
    Inherits C1.Silverlight.FlexGrid.CellFactory
    Private _text As String

    Public Sub New()
    End Sub

    Public Sub New(searchString As String)
        _text = searchString
    End Sub

    Public Overrides Sub CreateCellContent(grid As C1.Silverlight.FlexGrid.C1FlexGrid, bdr As Border, range As C1.Silverlight.FlexGrid.CellRange)
        MyBase.CreateCellContent(grid, bdr, range)

        Dim tb = TryCast(bdr.Child, TextBlock)
        If tb IsNot Nothing Then
            HighlightCell(tb)
        End If
    End Sub

    Private Sub HighlightCell(tb As TextBlock)
        If String.Empty <> _text Then
            Dim stringContent = tb.Text
            If stringContent.ToLower().Contains(_text.ToLower()) Then
                Dim runsToHighlight = New List(Of Run)()
                Dim newInlines = BuildRuns(stringContent, _text, runsToHighlight)

                ' apply new splitted InlineCollection
                tb.Inlines.Clear()
                For Each il As Run In newInlines
                    tb.Inlines.Add(il)
                Next
                ' apply styles:
                ' red color to the matching text
                ' Bold FontWeight too
                For Each r As Run In runsToHighlight
                    r.Foreground = New SolidColorBrush(Colors.Red)
                    r.FontWeight = FontWeights.Bold
                Next
            End If
        End If
    End Sub

    Private Function BuildRuns(text As String, filterText As String, runsToHighlight As List(Of Run)) As List(Of Run)
        Dim runs = New List(Of Run)()
        Dim i As Integer = 0

        While i < text.Length
            Dim pos = text.IndexOf(filterText, i, StringComparison.CurrentCultureIgnoreCase)
            ' not matching text in the head
            If i < pos Then
                runs.Add(New Run() With {.Text = text.Substring(i, pos - i)})
            End If

            If pos = -1 Then
                ' not matching text in the tail
                runs.Add(New Run() With {.Text = text.Substring(i)})
                i = text.Length
            Else
                ' new matching text
                Dim hRun = New Run() With {.Text = text.Substring(pos, filterText.Length)}
                runs.Add(hRun)
                runsToHighlight.Add(hRun)
                i = pos + filterText.Length
            End If
        End While
        Return runs
    End Function

End Class

Public Class TestData

    Public Property Name() As String
        Get
            Return m_Name
        End Get
        Set(value As String)
            m_Name = value
        End Set
    End Property
    Private m_Name As String

    Public Property Title() As String
        Get
            Return m_Title
        End Get
        Set(value As String)
            m_Title = value
        End Set
    End Property
    Private m_Title As String

End Class
