﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.OleDb;

namespace C1FlexGridAutoScrolling
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        int toprow;
        int lastrow;
        int lastrow_visible;
        int count;
        
        private void Form1_Load(object sender, EventArgs e)
        {
            string strSelect = "select * from Products";
            string strConn = GetConnectionString();
            OleDbDataAdapter da = new OleDbDataAdapter(strSelect, strConn);
            DataTable dt = new DataTable("Products");
            da.Fill(dt);
            // bind to grid
            c1FlexGrid1.DataSource = dt;
            // Get the index of the Top and Bottom rows in the start and the total count of the rows available
            toprow = c1FlexGrid1.TopRow;
            lastrow_visible = c1FlexGrid1.BottomRow;
            count = c1FlexGrid1.Rows.Count;
            lastrow = c1FlexGrid1.BottomRow;
            timer1.Start();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            // On each tick of the timer, change the index of the Top and Bottom row in the view range of the C1FlexGrid
            if ((lastrow <= count))
            {
                c1FlexGrid1.TopRow = toprow;
                toprow = (toprow + 1);
                lastrow = (lastrow + 1);
            }
            else
            {
                // When the scrollbar reaches the end of the flex, reset the index of TopRow visible to 1
                toprow = 1;
                lastrow = lastrow_visible;
                System.Threading.Thread.Sleep(100);
                c1FlexGrid1.TopRow = 1;
            }
        }

        private void c1FlexGrid1_AfterScroll(object sender, C1.Win.C1FlexGrid.RangeEventArgs e)
        {
            // Get the index of the top row in the view range
            if ((e.NewRange.TopRow == (e.OldRange.TopRow + 1))) 
            {
                toprow = e.NewRange.TopRow;
            }
            else 
            {
                toprow = (e.NewRange.TopRow + 1);
            }
            // Get the index of the last row in the view range
            if ((e.NewRange.BottomRow <= c1FlexGrid1.Rows.Count)) 
            {
                    lastrow = (e.NewRange.BottomRow + 1);
            }
        }

        private string GetConnectionString()
        {
            string path = (Environment.GetFolderPath(Environment.SpecialFolder.Personal) + "\\ComponentOne Samples\\Common");
            string conn = "provider=microsoft.jet.oledb.4.0;data source={0}\\c1nwind.mdb;";
            return string.Format(conn, path);
        }
    }
}
