﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.ServiceModel;
using WPF_Flex_Paging.PeopleServiceReference;
using System.Collections.ObjectModel;

namespace WPF_Flex_Paging
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        int _startRow;
        int _pageSize = 15;
        int _maxRecord = 100;
        ObservableCollection<PeopleClass> _people;

        public MainWindow()
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(MainWindow_Loaded);
            this.peopleDataGrid.ScrollPositionChanged += new EventHandler(peopleDataGrid_ScrollPositionChanged);
        }

        void MainWindow_Loaded(object sender, RoutedEventArgs e)
        {
            _startRow = 0;
            _people = new ObservableCollection<PeopleClass>();
            GetData(_startRow, _pageSize);
            peopleDataGrid.ItemsSource = _people;
            peopleDataGrid.VerticalAlignment = System.Windows.VerticalAlignment.Top;
        }

        void peopleDataGrid_ScrollPositionChanged(object sender, EventArgs e)
        {
            if (this._people.Count >= _maxRecord)
                return;

            if (this.peopleDataGrid.ViewRange.Row2 == this._people.Count - 1)
            {
                if ((_startRow + _pageSize) < _maxRecord)
                    GetData(_startRow, _startRow + _pageSize);
                else
                    GetData(_startRow, _startRow + (_maxRecord - _startRow));
            }

        }

        private void GetData(int startRow, int endRow)
        {
            PeopleServiceClient proxy = new PeopleServiceClient();
            var peopleList = proxy.GetData(startRow, endRow);
            _startRow += _pageSize;
            foreach (PeopleClass person in peopleList)
            {
                _people.Add(person);
            }
        }
    }
}
