﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Windows;
using System.Windows.Controls;
using C1.Silverlight;

namespace C1TreeViewDragDropSample
{
    public partial class Page : UserControl
    {
        CustomDragDrop dragDrop;
        public Page()
        {
            InitializeComponent();

            SampleTreeView.ItemsSource = BuildDepartmentTree();

            SampleTreeView.AllowDragDrop = true;
            dragDrop = new CustomDragDrop(SampleTreeView);
            SampleTreeView.DragOver += dragDrop.HandleDragOver;
            SampleTreeView.DragDrop += dragDrop.HandleDragDrop;
        }

        private ObservableCollection<object> BuildDepartmentTree()
        {
            ObservableCollection<object> itemsSource = new ObservableCollection<object>();
            IDictionary<int, Department> departmentDirectory = new Dictionary<int, Department>();

            // insert all departments as root nodes
            List<Department> departments = DataLoader.LoadDepartments();
            foreach (Department d in departments)
            {
                itemsSource.Add(d);
                departmentDirectory.Add(d.DepartmentID, d);
            }

            // insert all employees in their corresponding department
            List<Employee> employees = DataLoader.LoadEmployees();
            foreach (Employee e in employees)
            {
                Department d = departmentDirectory[e.DepartmentID];
                d.Employees.Add(e);
            }

            return itemsSource;
        }

        private void OnButtonChecked(object sender, RoutedEventArgs e)
        {
            RadioButton rb = sender as RadioButton;
            if (dragDrop != null)
            {
                dragDrop.Effect = (rb.Name.CompareTo("Move") == 0) ? DragDropEffect.Move : DragDropEffect.Copy;
            }
        }
    }
}
