
// Dummy classes for source code release
using System;
#if WINRT
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
#else
using System.Windows;
using System.Windows.Controls;
#endif
using System.ComponentModel;

namespace C1.Util.Licensing
{
    internal static class LicenseHelper
    {        
        internal static void License(Type type, FrameworkElement instance)
        {
        }
    }

#if !SILVERLIGHT && !WINDOWS_PHONE && !WINRT
    internal class ProviderInfo : LicenseProvider
    {
        public override License GetLicense(LicenseContext context, Type type, object instance, bool allowExceptions)
        {
            return null;
        }

        internal static void ShowAboutBox(object instance)
        {
        }
    }

    internal static class ProviderInfoWPF
    {
        static bool _isLicensed = false;

        internal static LicenseInfo Validate(Type type, FrameworkElement instance)
        {
            return null;
        }

        /// <summary>
        /// Perform license validation. Call this method from the licensed object's 
        /// constructor to save a license key at design time, validate it at runtime, 
        /// and display a nag dialog if a valid license is not found.
        /// <param name="type">Type of licensed object (use typeof() and not GetType()).</param>
        /// <param name="instance">Reference to the licensed object.</param>
        /// <param name="testDomain">Whether to test for an IdeDomainManager (ASP.NET design time that looks like runtime).</param>
        /// <returns>A <see cref="LicenseInfo"/> object that contains information about the license.</returns>
        /// </summary>
        internal static LicenseInfo Validate(Type type, FrameworkElement instance, bool testDomain)
        {
            return null;
        }
    }

    internal class LicenseInfo : License
    {
        public override void Dispose()
        {
        }
        public override string LicenseKey
        {
            get { return null; }
        }
    }
#endif

    internal class C1ProductInfoAttribute : Attribute
    {
        public C1ProductInfoAttribute(string productCode, string productGUID)
        {
        }
    }

}
namespace C1.Util.Localization
{
#if !WINRT
    [AttributeUsage(AttributeTargets.All)]
    internal class C1DescriptionAttribute : DescriptionAttribute
    {
        public C1DescriptionAttribute(string key)
        {
        }
        public C1DescriptionAttribute(string key, string description)
        {
        }
    }

    [AttributeUsage(AttributeTargets.All)]
    internal class C1CategoryAttribute : CategoryAttribute
    {
        public C1CategoryAttribute(string name)
            : base(name)
        {
        }
    }
#endif
}
//

namespace C1.Silverlight
{
    /// <summary>
    /// Dummy NagScreen 
    /// </summary>
    public class C1NagScreen 
        : Control 
    {
    }
}

internal class Public 
{ 
   internal const string Key = "";
#if SILVERLIGHT
#if SL5
    /// <summary>
    /// Defines the WPF platform specific suffix of a run-time assembly name.
    /// </summary>
    internal const string RunTimeNameSuffix = ".5";
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2010/Blend3-4 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet4NameSuffix = "";
#else
   /// <summary>
   /// Defines the WPF platform specific suffix of a run-time assembly name.
   /// </summary>
   internal const string RunTimeNameSuffix = "";
   /// <summary>
   /// Defines the WPF platform specific suffix of a VS2010/Blend3-4 design-time assembly name.
   /// </summary>
   internal const string DesignTimeNet4NameSuffix = "";
#endif
#elif CLR40
    /// <summary>
    /// Defines the WPF platform specific suffix of a run-time assembly name.
    /// </summary>
    internal const string RunTimeNameSuffix = ".4";
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2010/Blend3-4 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet4NameSuffix = "";
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2012 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet45NameSuffix = ".4.0.3";
#elif WINDOWS_PHONE
    /// <summary>
    /// Defines the WPF platform specific suffix of a run-time assembly name.
    /// </summary>
#if WP8
    internal const string RunTimeNameSuffix = ".8";
#else
    internal const string RunTimeNameSuffix = "";
#endif
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2010/Blend3-4 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet4NameSuffix = ".4.0";
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2012 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet45NameSuffix = ".4.0.3";
#elif !WINRT
    /// <summary>
    /// Defines the WPF platform specific suffix of a run-time assembly name.
    /// </summary>
    internal const string RunTimeNameSuffix = "";
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2010/Blend3-4 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet4NameSuffix = ".4.0";
    /// <summary>
    /// Defines the WPF platform specific suffix of a VS2012 design-time assembly name.
    /// </summary>
    internal const string DesignTimeNet45NameSuffix = ".4.0.3";
#endif
}

[AttributeUsage(AttributeTargets.Assembly | AttributeTargets.Class, Inherited = false, AllowMultiple = true)]
internal class C1ProductInfoAttribute : Attribute
{
    public C1ProductInfoAttribute(string productCode, string productGUID)
    {}
}