﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using C1.WPF.C1Chart;

namespace WPF_Chart_PointInViewPort
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Random rnd = new Random();
        public MainWindow()
        {
            InitializeComponent();
            chart.Loaded += (s, e) => UpdateList();
            CreateSampleChart(5, 100);
        }

        void CreateSampleChart(int nseries, int npoints)
        {
            chart.BeginUpdate();
            chart.Reset(true);

            for (int i = 0; i < nseries; i++)
            {
                var xvalues = new double[npoints];
                var yvalues = new double[npoints];
                for (int j = 0; j < npoints; j++)
                {
                    xvalues[j] = rnd.Next(0, 100);
                    yvalues[j] = rnd.Next(0, 100);
                }
                chart.Data.Children.Add(new XYDataSeries() { XValuesSource = xvalues, ValuesSource = yvalues });
            }

            chart.ChartType = ChartType.XYPlot;

            chart.Actions.Add(new ZoomAction());
            chart.Actions.Add(new ScaleAction() { Modifiers = ModifierKeys.Control });
            chart.Actions.Add(new TranslateAction() { Modifiers = ModifierKeys.Shift });
            chart.ActionLeave += chart_ActionLeave;
            chart.EndUpdate();
        }
        void chart_ActionLeave(object sender, EventArgs e)
        {
            UpdateList();
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            chart.View.AxisX.Scale = 1;
            chart.View.AxisY.Scale = 1;

            UpdateList();
        }
        void UpdateList()
        {
            var list = GetPointsInView(chart);
            listBox.ItemsSource = list;
            textBlock.Text = string.Format("{0} points", list.Count);
        }

        List<Point> GetPointsInView(C1Chart chart)
        {
            var list = new List<Point>();
            int nser = chart.Data.Children.Count;
            var xmin = GetAxisMin(chart.View.AxisX);
            var xmax = GetAxisMax(chart.View.AxisX);
            var ymin = GetAxisMin(chart.View.AxisY);
            var ymax = GetAxisMax(chart.View.AxisY);

            for (int i = 0; i < nser; i++)
            {
                var ds = chart.Data.Children[i] as XYDataSeries;
                if (ds != null)
                {
                    // fast access to data values
                    var values = ((IDataSeriesInfo)ds).GetValues();
                    if (values != null)
                    {
                        var len = values.GetLength(1);
                        for (int ipts = 0; ipts < len; ipts++)
                        {
                            var x = values[1, ipts];
                            var y = values[0, ipts];
                            if (!double.IsNaN(x) && !double.IsNaN(y))
                            {
                                if (xmin <= x && x <= xmax && ymin <= y && y <= ymax)
                                    list.Add(new Point(x, y));
                            }
                        }
                    }
                }
            }
            return list;
        }
        double GetAxisMin(Axis ax)
        {
            double range = (ax.ActualMax - ax.ActualMin) * ax.Scale;
            return ax.ActualMin + ax.Value * (ax.ActualMax - ax.ActualMin - range);
        }

        double GetAxisMax(Axis ax)
        {
            double range = (ax.ActualMax - ax.ActualMin) * ax.Scale;
            return ax.ActualMin + ax.Value * (ax.ActualMax - ax.ActualMin - range) + range;
        }
    }
}
