﻿Imports C1.WPF.C1Chart
Imports C1.WPF.C1Chart.Extended
Imports System.IO

Class MainWindow
    Dim cnt As Integer = 10
    Dim npts As Integer = 100
    Dim rnd As New Random()
    Dim charts As C1Chart()

    Public Sub New()

        ' This call is required by the designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.
        charts = New C1Chart(cnt - 1) {}
        ' create tabs with charts
        For i As Integer = 0 To cnt - 1
            charts(i) = New C1Chart() With {.ChartType = ChartType.Line}
            Dim values1 = New Double(npts - 1) {}
            Dim values2 = New Double(npts - 1) {}
            Dim values3 = New Double(npts - 1) {}

            For j As Integer = 0 To npts - 1
                values1(j) = rnd.[Next](100)
                values2(j) = rnd.[Next](100)
                values3(j) = rnd.[Next](100)
            Next
            charts(i).Data.Children.Add(New DataSeries() With {.ValuesSource = values1, .Label = "series1"})
            charts(i).Data.Children.Add(New DataSeries() With {.ValuesSource = values2, .Label = "series2"})
            charts(i).Data.Children.Add(New DataSeries() With {.ValuesSource = values3, .Label = "series3"})
            charts(i).Palette = ColorGeneration.Solstice
            charts(i).Children.Add(New C1ChartLegend() With {.Title = "Chart " & i})

             tabs.Items.Add(New TabItem() With {.Header = "Tab " & i, .Content = charts(i)})

        Next

    End Sub

    Private Sub SaveBtn_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)
        ' use size of visible chart
        Dim sz = New Size(charts(0).ActualWidth, charts(0).ActualHeight)
        For i As Integer = 0 To cnt - 1
            Using file__1 = File.Open("chart" & i & ".jpg", FileMode.Create)
                ' two arranges is neccesary to perform chart layout
                charts(i).Arrange(New Rect(0, 0, sz.Width, sz.Height))
                charts(i).Arrange(New Rect(0, 0, sz.Width, sz.Height))
                charts(i).UpdateLayout()

                charts(i).SaveImage(file__1, ImageFormat.Jpeg)
            End Using
        Next
    End Sub

    Private Sub Grid_Loaded(sender As System.Object, e As System.Windows.RoutedEventArgs)
        Application.Current.Resources.MergedDictionaries.Add(C1.WPF.Theming.C1Theme.GetCurrentThemeResources(New C1.WPF.Theming.ShinyBlue.C1ThemeShinyBlue()))
    End Sub
End Class
