﻿Imports C1.C1Excel

Public Class Form1

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        '"Creating an Excel Book and adding sheet"
        'Creating an Excel Book
        Dim xlbook1 As New C1XLBook()

        'Adding Sheet to the Book
        xlbook1.Sheets.Clear()
        Dim sheet1 As XLSheet = xlbook1.Sheets.Add("New Sheet 1")
        sheet1.DefaultColumnWidth = 2000


        ''"Adding content in the Sheet"
        sheet1(0, 0).Value = "OrderDate"
        sheet1(1, 0).Value = "23-01-2014"
        sheet1(2, 0).Value = "09-02-2014"
        sheet1(3, 0).Value = "26-02-2014"
        sheet1(4, 0).Value = "15-03-2014"
        sheet1(5, 0).Value = "4-1-2014"
        sheet1(6, 0).Value = "18-4-2014"
        sheet1(7, 0).Value = "5-5-2014"
        sheet1(8, 0).Value = "22-5-2014"
        sheet1(9, 0).Value = "6-8-2014"
        sheet1(10, 0).Value = "1-6-2014"

        sheet1(0, 1).Value = "Region"
        sheet1(1, 1).Value = "East"
        sheet1(2, 1).Value = "Central"
        sheet1(3, 1).Value = "Central"
        sheet1(4, 1).Value = "Central"
        sheet1(5, 1).Value = "West"
        sheet1(6, 1).Value = "East"
        sheet1(7, 1).Value = "Central"
        sheet1(8, 1).Value = "East"
        sheet1(9, 1).Value = "East"
        sheet1(10, 1).Value = "West"

        sheet1(0, 2).Value = "Representative"
        sheet1(1, 2).Value = "Jones"
        sheet1(2, 2).Value = "Kivell"
        sheet1(3, 2).Value = "Jardine"
        sheet1(4, 2).Value = "Gill"
        sheet1(5, 2).Value = "Sorvino"
        sheet1(6, 2).Value = "Jones"
        sheet1(7, 2).Value = "Andrews"
        sheet1(8, 2).Value = "Jardine"
        sheet1(9, 2).Value = "Thompson"
        sheet1(10, 2).Value = "Jones"

        sheet1(0, 3).Value = "Item"
        sheet1(1, 3).Value = "Pencil"
        sheet1(2, 3).Value = "Binder"
        sheet1(3, 3).Value = "Pencil"
        sheet1(4, 3).Value = "Pen"
        sheet1(5, 3).Value = "Pencil"
        sheet1(6, 3).Value = "Binder"
        sheet1(7, 3).Value = "Pencil"
        sheet1(8, 3).Value = "Pencil"
        sheet1(9, 3).Value = "Binder"
        sheet1(10, 3).Value = "Pen"

        sheet1(0, 4).Value = "Units"
        sheet1(1, 4).Value = 50
        sheet1(2, 4).Value = 36
        sheet1(3, 4).Value = 27
        sheet1(4, 4).Value = 56
        sheet1(5, 4).Value = 60
        sheet1(6, 4).Value = 75
        sheet1(7, 4).Value = 90
        sheet1(8, 4).Value = 32
        sheet1(9, 4).Value = 60
        sheet1(10, 4).Value = 95

        sheet1(0, 5).Value = "Unit Cost"
        sheet1(1, 5).Value = 1.99
        sheet1(2, 5).Value = 19.99
        sheet1(3, 5).Value = 4.99
        sheet1(4, 5).Value = 19.99
        sheet1(5, 5).Value = 2.99
        sheet1(6, 5).Value = 4.99
        sheet1(7, 5).Value = 1.99
        sheet1(8, 5).Value = 4.99
        sheet1(9, 5).Value = 1.99
        sheet1(10, 5).Value = 8.99

        sheet1(0, 6).Value = "Total"


        ''"Formatting the cell content"
        Dim style_all As New XLStyle(xlbook1)
        style_all.AlignHorz = XLAlignHorzEnum.Center
        style_all.AlignVert = XLAlignVertEnum.Center

        For j As Integer = 0 To 6
            sheet1.Columns(j).Style = style_all
        Next

        Dim style_header As New XLStyle(xlbook1)
        style_header.Font = New Font("Tahoma", 11, FontStyle.Bold Or FontStyle.Underline)
        style_header.BackColor = Color.DarkSlateGray
        style_header.ForeColor = Color.LightBlue
        style_header.AlignHorz = XLAlignHorzEnum.Center

        For i As Integer = 0 To 6
            ' Apply styles to the content.
            sheet1(0, i).Style = style_header
        Next


        ''"Styles to Rows and Columns"
        Dim style_col As New XLStyle(xlbook1)
        style_col.Font = New System.Drawing.Font("Arial", 12, FontStyle.Bold)
        style_col.ForeColor = Color.Green
        style_col.AlignHorz = XLAlignHorzEnum.Center

        Dim col As XLColumn = sheet1.Columns(6)
        col.Style = style_col


        ''"Applying Formulas to the cell content and Summing up the cell values"
        'Formula to calculate the Total units sold and Total order cost
        sheet1(11, 3).Value = "Total Units"
        sheet1(11, 4).Formula = "Sum(E2:E11)"

        sheet1(11, 5).Value = "Total Order Cost"
        sheet1(11, 6).Formula = "Sum(G2:G11)"

        'Formula to calculate the total cost
        For i As Integer = 2 To 11
            sheet1(i - 1, 6).Formula = "F" & i.ToString() & "*" & "E" & i.ToString()
        Next

        Dim style_total As New XLStyle(xlbook1)
        style_total.Font = New System.Drawing.Font(style_total.Font.FontFamily, 12, FontStyle.Bold)
        style_total.SetBorderStyle(XLLineStyleEnum.Medium)
        style_total.AlignHorz = XLAlignHorzEnum.Center

        sheet1(11, 3).Style = style_total
        sheet1(11, 4).Style = style_total

        sheet1(11, 5).Style = style_total
        sheet1(11, 6).Style = style_total



        ''"Adding Comment to a cell"
        xlbook1.Sheets(0).Comments.Add(11, 3, "Arpit", "Total Number of Units Sold")
        xlbook1.Sheets(0).Comments.Add(11, 4, "Arpit", "Total Number of Units Sold")

        xlbook1.Sheets(0).Comments.Add(11, 5, "Arpit", "Total Cost of the Order")
        xlbook1.Sheets(0).Comments.Add(11, 6, "Arpit", "Total Cost of the Order")


        ''"Merging cells and styling"
        'Select range to Merge
        Dim merge_range1 As XLCellRange = New C1.C1Excel.XLCellRange(2, 4, 1, 1)
        Dim merge_range2 As XLCellRange = New C1.C1Excel.XLCellRange(8, 9, 1, 1)
        Dim merge_range3 As XLCellRange = New C1.C1Excel.XLCellRange(7, 8, 3, 3)

        'Merge Cells
        sheet1.MergedCells.Add(merge_range1)
        sheet1.MergedCells.Add(merge_range2)
        sheet1.MergedCells.Add(merge_range3)

        ''"Copying cell content from one sheet to another"
        Dim sheet2 As XLSheet = xlbook1.Sheets.Add("New Sheet 2")
        For rows As Integer = 0 To 11
            For cols As Integer = 0 To 5
                sheet2(rows, cols).Value = sheet1(rows, cols).Value
            Next
        Next


        ''"Adding PageBreaks"
        sheet1.Rows(21).PageBreak = True
        sheet1.Columns(6).PageBreak = True


        ''"Adding Images"
        Dim img As Image = Image.FromFile("..\..\vbStationary.jpg")
        sheet1(13, 2).Value = img


        ''"Print Settings"
        Dim settings As XLPrintSettings = sheet1.PrintSettings
        settings.BlackAndWhite = True
        settings.Copies = 2
        settings.Header = "Sales Report"
        settings.Footer = "VB Stationers"
        settings.AlignWithMargins = True
        settings.MarginTop = 1
        settings.MarginBottom = 1
        settings.MarginLeft = 0
        settings.MarginRight = 0
        settings.Landscape = True
        settings.CenterHorizontal = True


        ''"Saving and Opening the Excel file and CSV file"
        'Saving the sheet as CSV files
        sheet1.SaveCsv("..\..\Sheet1.csv")

        'Saving the Excel Book
        xlbook1.Save("..\..\ExcelFile.xlsx")

        'Opening the Excel Book and CSV sheet
        System.Diagnostics.Process.Start("..\..\ExcelFile.xlsx")
        System.Diagnostics.Process.Start("..\..\Sheet1.csv")

        Me.Close()

    End Sub
End Class
