﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="WebForm1.aspx.vb" Inherits="SearchMultiColumnVb.WebForm1" %>

<%@ Register assembly="FarPoint.Web.Spread, Version=6.0.3505.2008, Culture=neutral, PublicKeyToken=327c3516b1b18457" namespace="FarPoint.Web.Spread" tagprefix="FarPoint" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
    <FarPoint:FpSpread ID="FpSpread1" runat="server" BorderColor="Black" 
        BorderStyle="Solid" BorderWidth="1px" Height="200" Width="400">
        <commandbar backcolor="Control" buttonfacecolor="Control" 
            buttonhighlightcolor="ControlLightLight" buttonshadowcolor="ControlDark">
        </commandbar>
        <sheets>
            <FarPoint:SheetView SheetName="Sheet1">
            </FarPoint:SheetView>
        </sheets>
    </FarPoint:FpSpread>
    <div>
    
    </div>
     <script type="text/javascript" language="javascript">
         window.onload = function () {
             var spread = document.getElementById("FpSpread1");
             spread.addEventListener("EditStart", onEditStart);
            
         }

         var comboBoxObj;

         function onEditStart(e) {
             if (e.cell.getAttribute("FpCellType") != "MultiColumnComboBoxCellType") return;
             var editor = document.getElementById(e.cell.getAttribute('FpEditorID'));
             if (editor == null) return;
             var textbox = document.getElementById(editor.id + "_Input");
             if (textbox == null) return;
             e.spread.editingTextbox = textbox;
             FarPoint.System.WebControl.MultiColumnComboBoxCellType.CheckInit(editor.id);
             comboBoxObj = eval(editor.id + "_Obj");
             textbox.addEventListener("keydown", onKeyDown);
         }

      
         function onKeyDown(e) {
            
             if (!comboBoxObj.getIsDrop()) comboBoxObj.DropDown();
             var innerSpread = comboBoxObj.getFpSpread();
             var rowCount = innerSpread.GetRowCount();
             var columnIndex = comboBoxObj.getEditColumnIndex();
             var activeRow = innerSpread.ActiveRow || innerSpread.GetActiveRow();
             if (e.keyCode == 13) {
                 this.value = innerSpread.GetValue(activeRow, columnIndex);
                 return;
             }
             else if (e.keyCode == 8) {
                 var str = this.value;
                 str = str.substring(0, str.length - 1);
                 this.value = str;
                 var text = this.value;
                 for (var i = 0; i < rowCount; i++) {
                     var value = innerSpread.GetValue(i, columnIndex);
                     if (value == text || (value.length > text.length && value.substr(0, text.length) == text)) {
                         innerSpread.ClearSelection();
                         innerSpread.AddSelection(i, -1, 1, -1);
                         innerSpread.SetActiveCell(i, 0);
                         this.value = text; //restore the old value which has been changed by SetActiveCell
                         break;
                     }
                 }
             }
             else {
                 this.value = this.value + e.char;
                 var text = this.value;
                 for (var i = 0; i < rowCount; i++) {
                     var value = innerSpread.GetValue(i, columnIndex);
                     if (value == text || (value.length > text.length && value.substr(0, text.length) == text)) {
                         innerSpread.ClearSelection();
                         innerSpread.AddSelection(i, -1, 1, -1);
                         innerSpread.SetActiveCell(i, 0);
                         this.value = text; //restore the old value which has been changed by SetActiveCell
                         break;
                     }
                 }
             }
         }
         </script>

</form>
</body>
</html>
