﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace PrintToPDFWithBackGroundImage_CS
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            fpSpread1.Sheets[0].Cells[5, 5].Value = 30;
            fpSpread1.Sheets[0].Cells[1, 1].Value = 15;
            fpSpread1.Sheets[0].Cells[2, 1].Value = 100;
            fpSpread1.BackgroundImage = pictureBox1.Image;
            fpSpread1.ActiveSheet.DefaultStyle.BackColor = Color.Transparent;
        }
        private void button1_Click(object sender, EventArgs e)
        {
            FarPoint.Win.Spread.PrintInfo printset = new FarPoint.Win.Spread.PrintInfo();
            printset.PrintToPdf = true;
            printset.PdfFileName = "ResultedPDF.pdf";
            printset.Opacity = 10;
            //Assign the printer settings and print
            fpSpread1.Sheets[0].PrintInfo = printset;
            fpSpread1.PrintSheet(0);
        }
        private void fpSpread1_PrintBackground(object sender, FarPoint.Win.Spread.PrintBackgroundEventArgs e)
        {
            System.Drawing.Drawing2D.GraphicsState saveState = e.Graphics.Save();
            Rectangle rect = e.SheetRectangle;
            rect.Width = (int)AdjustWorkaroundForPDFPrint((float)rect.Width);
            rect.Height = (int)AdjustWorkaroundForPDFPrint((float)rect.Height);
            e.Graphics.SetClip(rect);
            e.Graphics.SetClip(rect);
            e.Graphics.DrawImage(fpSpread1.BackgroundImage, rect);
            e.Graphics.Restore(saveState);
        }
        private float AdjustWorkaroundForPDFPrint(float value)
        {
            float _ptperInch = 72;
            //Points Per inch						
            float pixelPointFactor = (float)(_ptperInch / 96);
            //pixel point factor base on graphic dpi
            float displayPointFactor = (float)(_ptperInch / 100);
            //point factor base on display graphic unit
            return (float)(value * displayPointFactor / pixelPointFactor);
        }
        private void fpSpread1_PrintMessageBox(object sender, FarPoint.Win.Spread.PrintMessageBoxEventArgs e)
        {
            if (e.BeginPrinting)
            {
                fpSpread1.ActiveSheet.DefaultStyle.ResetBackColor();
            }
            else
            {
                fpSpread1.ActiveSheet.DefaultStyle.BackColor = Color.Transparent;
            }
        }
    }
}
