import * as wjcChart from 'wijmo/wijmo.chart';
import * as wjcCore from 'wijmo/wijmo';
/**
 * Specifies the attachment of the annotation.
 */
export declare enum AnnotationAttachment {
    /**
    * Coordinates of the annotation point are defined by the data series index and
    * the data point index. */
    DataIndex = 0,
    /** Annotation point is specified in data coordinates. */
    DataCoordinate = 1,
    /** Annotation point is specified as a relative position inside the control where
    * (0,0) is the top left corner and (1,1) is the bottom right corner.*/
    Relative = 2,
    /** The annotation point is specified in control's pixel coordinates.  */
    Absolute = 3,
}
/**
 * Specifies the position of the annotation.
 */
export declare enum AnnotationPosition {
    /** The annotation appears at the Center of the target point. */
    Center = 0,
    /** The annotation appears at the Top of the target point. */
    Top = 1,
    /** The annotation appears at the Bottom of the target point. */
    Bottom = 2,
    /** The annotation appears at the Left of the target point. */
    Left = 4,
    /** The annotation appears at the Right of the target point. */
    Right = 8,
}
/**
 * Represents the base class of annotations for the @see:AnnotationLayer.
 */
export declare class AnnotationBase {
    static _DATA_KEY: string;
    static _CSS_ANNOTATION: string;
    static _CSS_ANNO_TEXT: string;
    static _CSS_ANNO_SHAPE: string;
    private _attachment;
    private _point;
    private _seriesIndex;
    private _pointIndex;
    private _position;
    private _offset;
    private _style;
    private _isVisible;
    private _tooltip;
    private _name;
    _element: SVGElement;
    _layer: AnnotationLayer;
    /**
     * Initializes a new instance of the @see:AnnotationBase class.
     *
     * @param options A JavaScript object containing initialization data
     * for @see:AnnotationBase.
     */
    constructor(options?: any);
    private _copy(dst, src);
    _processOptions(key: any, dst: any, src: any): void;
    _resetDefaultValue(): void;
    /**
     * Gets or sets the attachment of the annotation.
     */
    attachment: AnnotationAttachment;
    /**
     * Gets or sets the point of the annotation.
     * The coordinates of points depends on the @see:attachment property.
     * See @see:AnnotationAttachment for further description.
     */
    point: wjcChart.DataPoint;
    /**
     * Gets or sets the data series index of the annotation.
     * Applies only when the <b>attachment</b> property is set to DataIndex.
     */
    seriesIndex: number;
    /**
     * Gets or sets the data point index of the annotation.
     * Applies only when the <b>attachment</b> property is set to DataIndex.
     */
    pointIndex: number;
    /**
     * Gets or sets the position of the annotation.
     * The position is relative to the @see:point.
     */
    position: AnnotationPosition;
    /**
     * Gets or sets the offset of the annotation from the @see:point.
     */
    offset: wjcCore.Point;
    /**
     * Gets or sets the style of the annotation.
     */
    style: any;
    /**
     * Gets or sets the visibility of the annotation.
     */
    isVisible: boolean;
    /**
     * Gets or sets the tooltip of the annotation.
     */
    tooltip: string;
    /**
     * Gets or sets the name of the annotation.
     */
    name: string;
    _toggleVisibility(visible: boolean): void;
    _getCSSClass(): string;
    /**
     * Render this annotation.
     *
     * @param engine The engine to render annotation.
     */
    render(engine: wjcChart.IRenderEngine): void;
    _render(engine: wjcChart.IRenderEngine): void;
    /**
     * Destroy this annotation
     */
    destroy(): void;
    _repaint(): void;
    _convertPoint(pt?: wjcChart.DataPoint): wjcCore.Point;
    _convertDataToLen(total: number, axis: wjcChart.Axis, val: any, converted?: boolean): number;
    _renderCenteredText(content: string, engine: wjcChart.IRenderEngine, point: wjcCore.Point, className?: string, angle?: number, style?: any): void;
    _adjustOffset(pt: wjcCore.Point, offset: wjcCore.Point): void;
    _getOffset(engine?: wjcChart.IRenderEngine): wjcCore.Point;
    _getPositionOffset(engine?: wjcChart.IRenderEngine): wjcCore.Point;
    _getSize(engine?: wjcChart.IRenderEngine): wjcCore.Size;
    _isValidPoint(pt: wjcCore.Point): boolean;
    _measureString(engine: wjcChart.IRenderEngine, text: string, className: string): wjcCore.Size;
}
/**
 * Represents a text annotation for the @see:AnnotationLayer.
 */
export declare class Text extends AnnotationBase {
    static _CSS_TEXT: string;
    private _text;
    /**
     * Initializes a new instance of the @see:Text annotation class.
     *
     * @param options A JavaScript object containing initialization data for @see:Text annotation.
     */
    constructor(options?: any);
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    /**
     * Gets or sets the text of the annotation.
     */
    text: string;
    _render(engine: wjcChart.IRenderEngine): void;
    _getSize(engine?: wjcChart.IRenderEngine): wjcCore.Size;
}
/**
 * Represents a base class of shape annotations for the @see:AnnotationLayer.
 */
export declare class Shape extends AnnotationBase {
    static _CSS_SHAPE: string;
    private _content;
    _shapeContainer: SVGGElement;
    /**
     * Initializes a new instance of the @see:Shape annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Shape annotation.
     */
    constructor(options?: any);
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    /**
     * Gets or sets the text of the annotation.
     */
    content: string;
    _render(engine: wjcChart.IRenderEngine): void;
    _getContentCenter(): wjcChart.DataPoint;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _renderText(engine: wjcChart.IRenderEngine): void;
}
/**
 * Represents an ellipse annotation for @see:AnnotationLayer.
 */
export declare class Ellipse extends Shape {
    static _CSS_ELLIPSE: string;
    private _width;
    private _height;
    /**
     * Initializes a new instance of the @see:Ellipse annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Ellipse annotation.
     */
    constructor(options?: any);
    /**
     * Gets or sets the width of the @see:Ellipse annotation.
     */
    width: number;
    /**
     * Gets or sets the height of the @see:Ellipse annotation.
     */
    height: number;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
}
/**
 * Represents a rectangle annotation for @see:AnnotationLayer.
 */
export declare class Rectangle extends Shape {
    static _CSS_RECTANGLE: string;
    private _width;
    private _height;
    /**
     * Initializes a new instance of the @see:Rectangle annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Rectangle annotation.
     */
    constructor(options?: any);
    /**
     * Gets or sets the width of the @see:Rectangle annotation.
     */
    width: number;
    /**
     * Gets or sets the height of the @see:Rectangle annotation.
     */
    height: number;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
}
/**
 * Represents a line annotation for @see:AnnotationLayer.
 */
export declare class Line extends Shape {
    static _CSS_LINE: string;
    private _start;
    private _end;
    private _cS;
    private _cE;
    /**
     * Initializes a new instance of the @see:Line annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Line annotation.
     */
    constructor(options?: any);
    /**
     * Gets or sets the start point of the @see:Line annotation.
     */
    start: wjcChart.DataPoint;
    /**
     * Gets or sets the end point of the Line annotation.
     */
    end: wjcChart.DataPoint;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _getContentCenter(): wjcChart.DataPoint;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
    _renderText(engine: wjcChart.IRenderEngine): void;
    _renderCenteredText(content: string, engine: wjcChart.IRenderEngine, point: wjcCore.Point, className?: string, angle?: number, style?: any): void;
}
/**
 * Represents a polygon annotation for @see:AnnotationLayer.
 */
export declare class Polygon extends Shape {
    static _CSS_POLYGON: string;
    private _points;
    /**
     * Initializes a new instance of the @see:Polygon annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Polygon annotation.
     */
    constructor(options?: any);
    _processOptions(key: any, dst: any, src: any): void;
    /**
     * Gets the collection of points of the @see:Polygon annotation.
     */
    points: wjcCore.ObservableArray;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _getContentCenter(): wjcChart.DataPoint;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
}
/**
 * Represents a circle annotation for @see:AnnotationLayer.
 */
export declare class Circle extends Shape {
    static _CSS_CIRCLE: string;
    private _radius;
    /**
     * Initializes a new instance of the @see:Circle annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Circle annotation.
     */
    constructor(options?: any);
    /**
     * Gets or sets the radius of the @see:Circle annotation.
     */
    radius: number;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
}
/**
 * Represents a square annotation for the @see:AnnotationLayer.
 */
export declare class Square extends Shape {
    static _CSS_SQUARE: string;
    private _length;
    /**
     * Initializes a new instance of the @see:Square annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Square annotation.
     */
    constructor(options?: any);
    /**
     * Gets or sets the length of the @see:Square annotation.
     */
    length: number;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
}
/**
 * Represents an image annotation for @see:AnnotationLayer.
 */
export declare class Image extends Shape {
    static _CSS_IMAGE: string;
    private _width;
    private _height;
    private _href;
    /**
     * Initializes a new instance of the @see:Image annotation class.
     *
     * @param options A JavaScript object containing initialization data for
     * @see:Image annotation.
     */
    constructor(options?: any);
    /**
     * Gets or sets the width of the @see:Image annotation.
     */
    width: number;
    /**
     * Gets or sets the height of the @see:Image annotation.
     */
    height: number;
    /**
     * Gets or sets the href of the @see:Image annotation.
     */
    href: string;
    _resetDefaultValue(): void;
    _getCSSClass(): string;
    _renderShape(engine: wjcChart.IRenderEngine): void;
    _getSize(): wjcCore.Size;
    private _applyStyle(el, style);
    private _deCase(s);
}
/**
 * Represents an annotation layer for @see:FlexChart and @see:FinancialChart.
 *
 * The AnnotationLayer contains a collection of various annotation elements: texts,
 * lines, images, rectangles etc.
 * To use the @see:AnnotationLayer, create annotations and push them to the layer's
 * items property.
 */
export declare class AnnotationLayer {
    static _CSS_Layer: string;
    private _items;
    private _engine;
    _layerEle: SVGGElement;
    private _plotrectId;
    private _tooltip;
    private _forceTTShowing;
    private _annoTTShowing;
    _chart: wjcChart.FlexChartCore;
    /**
     * Initializes a new instance of the @see:AnnotationLayer class.
     *
     * @param chart A chart to which the @see:AnnotationLayer is attached.
     * @param options A JavaScript object containing initialization data for
     * @see:AnnotationLayer.
     */
    constructor(chart: wjcChart.FlexChartCore, options?: any);
    _init(chart: wjcChart.FlexChartCore): void;
    private _lostFocus(evt);
    /**
     * Gets the collection of annotation elements in the @see:AnnotationLayer.
     */
    items: wjcCore.ObservableArray;
    /**
     * Gets the annotation element by name in the @see:AnnotationLayer.
     * @param name The annotation's name.
     */
    getItem(name: string): AnnotationBase;
    /**
     * Gets the annotation elements by name in the @see:AnnotationLayer.
     * @param name The annotations' name.
     */
    getItems(name: string): Array<AnnotationBase>;
    private _bindTooltip();
    _showTooltip(): boolean;
    private _toggleTooltip(tooltip, evt, parentNode);
    _getAnnotation(ele: any, parentNode: any): AnnotationBase;
    private _getAnnotationElement(ele, pNode);
    private _itemsChanged(items, e);
    private _renderAnnotations();
    _renderGroup(): void;
    _renderAnnotation(item: AnnotationBase): void;
    private _destroyAnnotations();
    private _destroyAnnotation(item);
}
