import * as wjcCore from 'wijmo/wijmo';
import * as wjcSelf from 'wijmo/wijmo.chart';
/**
 * Class that represents a data point (with x and y coordinates).
 *
 * X and Y coordinates can be specified as a number or a Date object(time-based data).
 */
export declare class DataPoint {
    /**
     * Gets or sets X coordinate value of this @see:DataPoint.
     */
    x: any;
    /**
     * Gets or sets Y coordinate value of this @see:DataPoint.
     */
    y: any;
    /**
     * Initializes a new instance of the @see:DataPoint class.
     *
     * @param x X coordinate of the new DataPoint.
     * @param y Y coordinate of the new DataPoint.
     */
    constructor(x?: any, y?: any);
}
/**
 * Provides arguments for @see:Series events.
 */
export declare class RenderEventArgs extends wjcCore.EventArgs {
    _engine: IRenderEngine;
    /**
     * Initializes a new instance of the @see:RenderEventArgs class.
     *
     * @param engine (@see:IRenderEngine) The rendering engine to use.
     */
    constructor(engine: IRenderEngine);
    /**
     * Gets the @see:IRenderEngine object to use for rendering the chart elements.
     */
    engine: IRenderEngine;
}
/**
 * Specifies the format of the image with embed base64-encoded binary data.
 */
export declare enum ImageFormat {
    /** Gets the W3C Portable Network Graphics (PNG) image format. */
    Png = 0,
    /** Gets the Joint Photographic Experts Group (JPEG) image format. */
    Jpeg = 1,
    /** Gets the Scalable Vector Graphics(SVG) image format. */
    Svg = 2,
}
/**
 * The @see:FlexChartBase control from which the FlexChart and FlexPie derive.
 */
export declare class FlexChartBase extends wjcCore.Control implements _IPalette {
    static _WIDTH: number;
    static _HEIGHT: number;
    static _SELECTION_THRESHOLD: number;
    _items: any;
    _cv: wjcCore.ICollectionView;
    private _palette;
    private _selectionMode;
    private _itemFormatter;
    _selectionIndex: number;
    _options: any;
    private _plotMargin;
    _header: string;
    _headerStyle: any;
    _footer: string;
    _footerStyle: any;
    _legend: Legend;
    _defPalette: string[];
    _notifyCurrentChanged: boolean;
    _rectFooter: wjcCore.Rect;
    _rectHeader: wjcCore.Rect;
    _rectChart: wjcCore.Rect;
    _rectLegend: wjcCore.Rect;
    _currentRenderEngine: IRenderEngine;
    _legendHost: SVGGElement;
    private _needBind;
    private _toShow;
    private _toHide;
    _tooltip: ChartTooltip;
    /**
     * Gets or sets the array or @see:ICollectionView object that contains the data used to create the chart.
     */
    itemsSource: any;
    /**
     * Gets the @see:ICollectionView object that contains the chart data.
     */
    collectionView: wjcCore.ICollectionView;
    /**
     * Gets or sets an array of default colors to use for displaying each series.
     *
     * The array contains strings that represents CSS colors. For example:
     * <pre>
     * // use colors specified by name
     * chart.palette = ['red', 'green', 'blue'];
     * // or use colors specified as rgba-values
     * chart.palette = [
     *   'rgba(255,0,0,1)',
     *   'rgba(255,0,0,0.8)',
     *   'rgba(255,0,0,0.6)',
     *   'rgba(255,0,0,0.4)'];
     * </pre>
     *
     * There is a set of predefined palettes in the @see:Palettes class that you can use, for example:
     * <pre>
     * chart.palette = wijmo.chart.Palettes.coral;
     * </pre>
     */
    palette: string[];
    /**
     * Gets or sets the plot margin in pixels.
     *
     * The plot margin represents the area between the edges of the control
     * and the plot area.
     *
     * By default, this value is calculated automatically based on the space
     * required by the axis labels, but you can override it if you want
     * to control the precise position of the plot area within the control
     * (for example, when aligning multiple chart controls on a page).
     *
     * You may set this property to a numeric value or to a CSS-style
     * margin specification. For example:
     *
     * <pre>
     * // set the plot margin to 20 pixels on all sides
     * chart.plotMargin = 20;
     * // set the plot margin for top, right, bottom, left sides
     * chart.plotMargin = '10 15 20 25';
     * // set the plot margin for top/bottom (10px) and left/right (20px)
     * chart.plotMargin = '10 20';
     * </pre>
     */
    plotMargin: any;
    /**
     * Gets or sets the chart legend.
     */
    legend: Legend;
    /**
     * Gets or sets the text displayed in the chart header.
     */
    header: string;
    /**
     * Gets or sets the text displayed in the chart footer.
     */
    footer: string;
    /**
     * Gets or sets the style of the chart header.
     */
    headerStyle: any;
    /**
     * Gets or sets the style of the chart footer.
     */
    footerStyle: any;
    /**
     * Gets or sets an enumerated value indicating whether or what is
     * selected when the user clicks the chart.
     */
    selectionMode: SelectionMode;
    /**
     * Gets or sets the item formatter function that allows you to customize
     * the appearance of data points. See the Explorer sample's <a target="_blank"
     * href="http://demos.wijmo.com/5/Angular/Explorer/Explorer/#/chart/itemFormatter">
     * Item Formatter</a> for a demonstration.
     */
    itemFormatter: Function;
    /**
     * Occurs before the chart starts rendering data.
     */
    rendering: wjcCore.Event;
    /**
     * Occurs after the chart finishes rendering.
     */
    rendered: wjcCore.Event;
    /**
     * Raises the @see:rendered event.
     *
     * @param e The @see:RenderEventArgs object used to render the chart.
     */
    onRendered(e: RenderEventArgs): void;
    /**
     * Raises the @see:rendering event.
     *
     * @param e The @see:RenderEventArgs object used to render the chart.
     */
    onRendering(e: RenderEventArgs): void;
    /**
     * Save chart to an image file.
     *
     * @param filename The filename for the exported image file including extension. Supported types are PNG, JPEG, SVG.
     */
    saveImageToFile(filename: string): void;
    /**
     * Save chart to image data url.
     *
     * @param format The @see:ImageFormat for the exported image.
     * @param done A function to be called after data url is generated. The function gets passed the data url as its argument.
     */
    saveImageToDataUrl(format: ImageFormat, done: Function): void;
    _exportToImage(extension: any, processDataURI: any): void;
    /**
     * Refreshes the chart.
     *
     * @param fullUpdate A value indicating whether to update the control layout as well as the content.
     */
    refresh(fullUpdate?: boolean): void;
    /**
     * Checks whether this control contains the focused element.
     */
    containsFocus(): boolean;
    /**
     * Occurs after the selection changes, whether programmatically
     * or when the user clicks the chart. This is useful, for example,
     * when you want to update details in a textbox showing the current
     * selection.
     */
    selectionChanged: wjcCore.Event;
    /**
     * Raises the @see:selectionChanged event.
     */
    onSelectionChanged(e?: wjcCore.EventArgs): void;
    onLostFocus(e?: wjcCore.EventArgs): void;
    private _cvCollectionChanged(sender, e);
    private _cvCurrentChanged(sender, e);
    /**
    * Gets a color from the palette by index.
    *
    * @param index The index of the color in the palette.
    */
    _getColor(index: number): string;
    /**
     * Gets a lighter color from the palette by index.
     *
     * @param index The index of the color in the palette.
     */
    _getColorLight(index: number): string;
    _bindChart(): void;
    _clearCachedValues(): void;
    _render(engine: IRenderEngine): void;
    _performBind(): void;
    _refreshChart(): void;
    _drawTitle(engine: IRenderEngine, rect: wjcCore.Rect, title: string, style: any, isFooter: boolean): wjcCore.Rect;
    _toControl(pt: any, y?: number): wjcCore.Point;
    _highlightItems(items: any, cls: any, selected: boolean): void;
    _parseMargin(value: any): any;
    _showToolTip(content: any, rect: any): void;
    _hideToolTip(): void;
    private _clearTimeouts();
    _getHostOffset(): wjcCore.Point;
    _getHostSize(): wjcCore.Size;
    _getHostComputedStyle(): CSSStyleDeclaration;
    _find(elem: SVGElement, names: string[]): any[];
}
export interface _IHitArea {
    contains(pt: wjcCore.Point): boolean;
    distance(pt: wjcCore.Point): number;
    tag: any;
}
export declare class _KeyWords {
    private _keys;
    constructor();
    replace(s: string, ht: HitTestInfo): string;
    getValue(key: string, ht: HitTestInfo, fmt?: string): string;
}
/**
 * The @see:FlexPie control provides pie and doughnut charts with selectable
 * slices.
 *
 * To use the @see:FlexPie control, set the @see:FlexPie.itemsSource property
 * to an array containing the data and use the @see:FlexPie.binding and
 * @see:FlexPie.bindingName properties to set the properties that contain
 * the item values and names.
 */
export declare class FlexPie extends FlexChartBase {
    private static _MARGIN;
    private _binding;
    private _bindingName;
    _areas: any[];
    private _keywords;
    private _startAngle;
    private _innerRadius;
    private _offset;
    private _reversed;
    private _isAnimated;
    private _selectedItemPosition;
    private _selectedItemOffset;
    private _pieGroup;
    private _rotationAngle;
    private _center;
    private _radius;
    private _selectedOffset;
    private _selectedIndex;
    private _angles;
    private _selectionAnimationID;
    private _lbl;
    _values: number[];
    _labels: string[];
    _pels: any[];
    _sum: number;
    /**
     * Initializes a new instance of the @see:FlexPie class.
     *
     * @param element The DOM element that hosts the control, or a selector for the host element (e.g. '#theCtrl').
     * @param options A Javascript object containing initialization data for the control.
     */
    constructor(element: any, options?: any);
    /**
     * Gets or sets the name of the property that contains the chart values.
     */
    binding: string;
    /**
     * Gets or sets the name of the property that contains the name of the data items.
     */
    bindingName: string;
    /**
     * Gets or sets the starting angle for the pie slices, in degrees.
     *
     * Angles are measured clockwise, starting at the 9 o'clock position.
     */
    startAngle: number;
    /**
     * Gets or sets the offset of the slices from the pie center.
     *
     * The offset is measured as a fraction of the pie radius.
     */
    offset: number;
    /**
     * Gets or sets the size of the pie's inner radius.
     *
     * The inner radius is measured as a fraction of the pie radius.
     *
     * The default value for this property is zero, which creates
     * a pie. Setting this property to values greater than zero
     * creates pies with a hole in the middle, also known as
     * doughnut charts.
     */
    innerRadius: number;
    /**
     * Gets or sets a value that determines whether angles are reversed
     * (counter-clockwise).
     *
     * The default value is false, which causes angles to be measured in
     * the clockwise direction.
     */
    reversed: boolean;
    /**
     * Gets or sets the position of the selected slice.
     *
     * Setting this property to a value other than 'None' causes
     * the pie to rotate when an item is selected.
     *
     * Note that in order to select slices by clicking the chart,
     * you must set the @see:selectionMode property to "Point".
     */
    selectedItemPosition: Position;
    /**
     * Gets or sets the offset of the selected slice from the pie center.
     *
     * Offsets are measured as a fraction of the pie radius.
     */
    selectedItemOffset: number;
    /**
     * Gets or sets a value indicating whether to use animation when items are selected.
     *
     * See also the @see:selectedItemPosition and @see:selectionMode
     * properties.
     */
    isAnimated: boolean;
    /**
     * Gets the chart's @see:Tooltip.
     */
    tooltip: ChartTooltip;
    /**
     * Gets or sets the point data label.
     */
    dataLabel: PieDataLabel;
    /**
     * Gets or sets the index of the selected slice.
     */
    selectedIndex: number;
    _getLabelsForLegend(): string[];
    /**
     * Gets a @see:HitTestInfo object with information about the specified point.
     *
     * @param pt The point to investigate, in window coordinates.
     * @param y The Y coordinate of the point (if the first parameter is a number).
     * @return A HitTestInfo object containing information about the point.
     */
    hitTest(pt: any, y?: number): HitTestInfo;
    _performBind(): void;
    _initData(): void;
    _getBindData(item: any, values: any, labels: any, binding: any, bindingName: any): number;
    _render(engine: IRenderEngine): void;
    _renderData(engine: IRenderEngine, rect: wjcCore.Rect, g: any): void;
    _renderPie(engine: any, radius: any, innerRadius: any, startAngle: any, offset: any): void;
    _getCenter(): wjcCore.Point;
    _renderSlices(engine: any, values: any, sum: any, radius: any, innerRadius: any, startAngle: any, totalSweep: any, offset: any): void;
    _renderSlice(engine: any, cx: any, cy: any, currentAngle: any, idx: any, radius: any, innerRadius: any, startAngle: any, sweep: any, totalSweep: any): void;
    _renderLabels(engine: IRenderEngine): void;
    _drawSlice(engine: IRenderEngine, i: number, reversed: boolean, cx: number, cy: number, r: number, irad: number, angle: number, sweep: number): void;
    _measureLegendItem(engine: IRenderEngine, name: string): wjcCore.Size;
    _drawLegendItem(engine: IRenderEngine, rect: wjcCore.Rect, i: number, name: string): void;
    private _getLabelContent(ht, content);
    private _select(pointIndex, animate?);
    _highlightCurrent(): void;
    _highlight(selected: boolean, pointIndex: number, animate?: boolean): void;
    _animateSelectionAngle(target: number, duration: number): void;
}
export interface _ISegment {
    center: wjcCore.Point;
    radius: number;
    langle: number;
    angle: number;
    sweep: number;
}
export declare class _PieSegment implements _IHitArea, _ISegment {
    private _center;
    private _angle;
    private _sweep;
    private _radius;
    private _radius2;
    private _isFull;
    private _originAngle;
    private _originSweep;
    constructor(center: wjcCore.Point, radius: number, angle: number, sweep: number);
    contains(pt: wjcCore.Point): boolean;
    distance(pt: wjcCore.Point): number;
    center: wjcCore.Point;
    radius: number;
    langle: number;
    angle: number;
    sweep: number;
    tag: any;
}
export declare class _DonutSegment implements _IHitArea, _ISegment {
    private _center;
    private _angle;
    private _sweep;
    private _originAngle;
    private _originSweep;
    private _radius;
    private _radius2;
    private _iradius;
    private _iradius2;
    private _isFull;
    constructor(center: wjcCore.Point, radius: number, innerRadius: number, angle: number, sweep: number);
    contains(pt: wjcCore.Point): boolean;
    distance(pt: wjcCore.Point): number;
    center: wjcCore.Point;
    radius: number;
    langle: number;
    angle: number;
    sweep: number;
    innerRadius: number;
    tag: any;
}
/**
 * Specifies whether and how to stack the chart's data values.
 */
export declare enum Stacking {
    /** No stacking. Each series object is plotted independently. */
    None = 0,
    /** Stacked charts show how each value contributes to the total. */
    Stacked = 1,
    /** 100% stacked charts show how each value contributes to the total with the relative size of
     * each series representing its contribution to the total. */
    Stacked100pc = 2,
}
/**
 * Specifies what is selected when the user clicks the chart.
 */
export declare enum SelectionMode {
    /** Select neither series nor data points when the user clicks the chart. */
    None = 0,
    /** Select the whole @see:Series when the user clicks it on the chart. */
    Series = 1,
    /** Select the data point when the user clicks it on the chart. Since Line, Area, Spline,
     * and SplineArea charts do not render individual data points, nothing is selected with this
     * setting on those chart types. */
    Point = 2,
}
/**
 * The core charting control for @see:FlexChart.
 *
 */
export declare class FlexChartCore extends FlexChartBase {
    static _CSS_AXIS_X: string;
    static _CSS_AXIS_Y: string;
    static _CSS_LINE: string;
    static _CSS_GRIDLINE: string;
    static _CSS_TICK: string;
    static _CSS_GRIDLINE_MINOR: string;
    static _CSS_TICK_MINOR: string;
    static _CSS_LABEL: string;
    static _CSS_LEGEND: string;
    static _CSS_HEADER: string;
    static _CSS_FOOTER: string;
    static _CSS_TITLE: string;
    static _CSS_SELECTION: string;
    static _CSS_PLOT_AREA: string;
    static _FG: string;
    private _series;
    private _axes;
    private _pareas;
    private _axisX;
    private _axisY;
    private _selection;
    private _interpolateNulls;
    private _legendToggle;
    private _symbolSize;
    private _dataInfo;
    _plotRect: wjcCore.Rect;
    private __barPlotter;
    private __linePlotter;
    private __areaPlotter;
    private __bubblePlotter;
    private __financePlotter;
    private __funnelPlotter;
    private __boxPlotter;
    private _plotters;
    private _binding;
    private _bindingX;
    _rotated: boolean;
    _stacking: wjcSelf.Stacking;
    private _lbl;
    _xlabels: string[];
    _xvals: number[];
    _xDataType: wjcCore.DataType;
    private _hitTester;
    private _lblAreas;
    private _keywords;
    private _curPlotter;
    /**
     * Initializes a new instance of the @see:FlexChart class.
     *
     * @param element The DOM element that will host the control, or a selector for the host element (e.g. '#theCtrl').
     * @param options A JavaScript object containing initialization data for the control.
     */
    constructor(element: any, options?: any);
    _initAxes(): void;
    /**
     * Gets the collection of @see:Series objects.
     */
    series: wjcCore.ObservableArray;
    /**
     * Gets the collection of @see:Axis objects.
     */
    axes: wjcCore.ObservableArray;
    /**
     * Gets or sets the main X axis.
     */
    axisX: Axis;
    /**
     * Gets or sets the main Y axis.
     */
    axisY: Axis;
    /**
     * Gets the collection of @see:PlotArea objects.
     */
    plotAreas: PlotAreaCollection;
    /**
     * Gets or sets the name of the property that contains the Y values.
     */
    binding: string;
    /**
     * Gets or sets the name of the property that contains the X data values.
     */
    bindingX: string;
    /**
     * Gets or sets the size of the symbols used for all Series objects in this @see:FlexChart.
     *
     * This property may be overridden by the symbolSize property on each @see:Series object.
     */
    symbolSize: number;
    /**
     * Gets or sets a value that determines whether to interpolate
     * null values in the data.
     *
     * If true, the chart interpolates the value of any missing data
     * based on neighboring points. If false, it leaves a break in
     * lines and areas at the points with null values.
     */
    interpolateNulls: boolean;
    /**
     * Gets or sets a value indicating whether clicking legend items toggles the
     * series visibility in the chart.
     */
    legendToggle: boolean;
    /**
     * Gets the chart @see:Tooltip object.
     *
     * The tooltip content is generated using a template that may contain any of the following
     * parameters:
     *
     * <ul>
     *  <li><b>propertyName</b>:    Any property of the data object represented by the point.</li>
     *  <li><b>seriesName</b>:      Name of the series that contains the data point (FlexChart only).</li>
     *  <li><b>pointIndex</b>:      Index of the data point.</li>
     *  <li><b>value</b>:           <b>Value</b> of the data point (y-value for @see:FlexChart, item value for @see:FlexPie).</li>
     *  <li><b>x</b>:               <b>x</b>-value of the data point (FlexChart only).</li>
     *  <li><b>y</b>:               <b>y</b>-value of the data point (FlexChart only).</li>
     *  <li><b>name</b>:            <b>Name</b> of the data point (x-value for @see:FlexChart or legend entry for @see:FlexPie).</li>
     * </ul>
     *
     * To modify the template, assign a new value to the tooltip's content property.
     * For example:
     *
     * <pre>
     * chart.tooltip.content = '&lt;b&gt;{seriesName}&lt;/b&gt; ' +
     *    '&lt;img src="resources/{x}.png"/&gt;&lt;br/&gt;{y}';
     * </pre>
     *
     * You can disable chart tooltips by setting the template to an empty string.
     *
     * You can also use the @see:tooltip property to customize tooltip parameters
     * such as @see:Tooltip.showDelay and @see:Tooltip.hideDelay:
     *
     * <pre>
     * chart.tooltip.showDelay = 1000;
     * </pre>
     *
     * See @see:ChartTooltip properties for more details and options.
     */
    tooltip: ChartTooltip;
    /**
     * Gets or sets the point data label.
     */
    dataLabel: DataLabel;
    /**
     * Gets or sets the selected chart series.
     */
    selection: SeriesBase;
    /**
     * Occurs when the series visibility changes, for example when the legendToggle
     * property is set to true and the user clicks the legend.
    */
    seriesVisibilityChanged: wjcCore.Event;
    /**
     * Raises the @see:seriesVisibilityChanged event.
     *
     * @param e The @see:SeriesEventArgs object that contains the event data.
     */
    onSeriesVisibilityChanged(e: SeriesEventArgs): void;
    /**
     * Gets a @see:HitTestInfo object with information about the specified point.
     *
     * @param pt The point to investigate, in window coordinates.
     * @param y The Y coordinate of the point (if the first parameter is a number).
     * @return A HitTestInfo object with information about the point.
     */
    hitTest(pt: any, y?: number): HitTestInfo;
    /**
     * Converts a @see:Point from control coordinates to chart data coordinates.
     *
     * @param pt The point to convert, in control coordinates.
     * @param y The Y coordinate of the point (if the first parameter is a number).
     * @return The point in chart data coordinates.
     */
    pointToData(pt: any, y?: number): wjcCore.Point;
    /**
     * Converts a @see:Point from data coordinates to control coordinates.
     *
     * @param pt @see:Point in data coordinates, or X coordinate of a point in data coordinates.
     * @param y Y coordinate of the point (if the first parameter is a number).
     * @return The @see:Point in control coordinates.
     */
    dataToPoint(pt: any, y?: number): wjcCore.Point;
    _copy(key: string, value: any): boolean;
    _createSeries(): SeriesBase;
    _clearCachedValues(): void;
    _performBind(): void;
    _hitTestSeries(pt: wjcCore.Point, seriesIndex: number): HitTestInfo;
    _hitTestData(pt: any): HitTestInfo;
    _hitTestLabels(pt: wjcCore.Point): _IHitArea;
    private static _dist2(p1, p2);
    static _dist(p0: wjcCore.Point, p1: wjcCore.Point, p2: wjcCore.Point): number;
    static _distToSegmentSquared(p: wjcCore.Point, v: wjcCore.Point, w: wjcCore.Point): number;
    _isRotated(): boolean;
    _plotrectId: string;
    _getChartType(): ChartType;
    _render(engine: IRenderEngine, applyElement?: boolean): void;
    private _renderLabels(engine);
    private _getAxes();
    private _clearPlotters();
    _initPlotter(plotter: _IPlotter): void;
    private _barPlotter;
    private _linePlotter;
    private _areaPlotter;
    private _bubblePlotter;
    private _financePlotter;
    private _funnelPlotter;
    private _boxPlotter;
    _getPlotter(series: SeriesBase): _IPlotter;
    _layout(rect: wjcCore.Rect, size: wjcCore.Size, engine: IRenderEngine): void;
    private _layoutSingle(rect, size, engine);
    private _layoutMultiple(rect, size, engine);
    private _convertX(x, left, right);
    private _convertY(y, top, bottom);
    _getLabelContent(ht: HitTestInfo, content: any): string;
    private _select(newSelection, pointIndex);
    private _highlightCurrent();
    private _highlight(series, selected, pointIndex);
    _updateAuxAxes(axes: Axis[], isRotated: boolean): void;
    static _contains(rect: wjcCore.Rect, pt: wjcCore.Point): boolean;
    static _intersects(rect1: wjcCore.Rect, rect2: wjcCore.Rect): boolean;
    static _epoch: number;
    static _msPerDay: number;
    static _toOADate(date: Date): number;
    static _fromOADate(val: number): Date;
    static _renderText(engine: IRenderEngine, text: string, pos: wjcCore.Point, halign: any, valign: any, className?: string, groupName?: string, style?: any, test?: any): wjcCore.Rect;
    static _renderRotatedText(engine: IRenderEngine, text: string, pos: wjcCore.Point, halign: any, valign: any, center: wjcCore.Point, angle: number, className: string, style?: any): void;
}
/**
 * Analyzes chart data.
 */
export declare class _DataInfo {
    private minY;
    private maxY;
    private minX;
    private maxX;
    private minXp;
    private minYp;
    private dataTypeX;
    private dataTypeY;
    private stackAbs;
    private _xvals;
    private dx;
    constructor();
    analyse(seriesList: any, isRotated: boolean, stacking: Stacking, xvals: Array<number>, logx: boolean, logy: boolean): void;
    _parseYVal(val: any, xval: any, custom: any, stackAbs: any, stackPos: any, stackNeg: any): void;
    getMinY(): number;
    getMaxY(): number;
    getMinX(): number;
    getMaxX(): number;
    getMinXp(): number;
    getMinYp(): number;
    getDeltaX(): number;
    getDataTypeX(): wjcCore.DataType;
    getDataTypeY(): wjcCore.DataType;
    getStackedAbsSum(key: number): number;
    getXVals(): Array<number>;
    static isValid(value: number): boolean;
}
/**
 * Represents the chart palette.
 */
export interface _IPalette {
    _getColor(i: number): string;
    _getColorLight(i: number): string;
}
/**
 * Extends the @see:Tooltip class to provide chart tooltips.
 */
export declare class ChartTooltip extends wjcCore.Tooltip {
    private _content;
    private _threshold;
    /**
     * Initializes a new instance of the @see:ChartTooltip class.
     */
    constructor();
    /**
     * Gets or sets the tooltip content.
     *
     * The tooltip content can be specified as a string or as a function that
     * takes a @see:HitTestInfo object as a parameter.
     *
     * When the tooltip content is a string, it may contain any of the following
     * parameters:
     *
     * <ul>
     *  <li><b>propertyName</b>:    Any property of the data object represented by the point.</li>
     *  <li><b>seriesName</b>:      Name of the series that contains the data point (FlexChart only).</li>
     *  <li><b>pointIndex</b>:      Index of the data point.</li>
     *  <li><b>value</b>:           <b>Value</b> of the data point (y-value for @see:FlexChart, item value for @see:FlexPie).</li>
     *  <li><b>x</b>:               <b>x</b>-value of the data point (FlexChart only).</li>
     *  <li><b>y</b>:               <b>y</b>-value of the data point (FlexChart only).</li>
     *  <li><b>name</b>:            <b>Name</b> of the data point (x-value for @see:FlexChart or legend entry for @see:FlexPie).</li>
     * </ul>
     *
     * Parameters must be enclosed in single curly brackets. For example:
     *
     * <pre>
     *   // 'country' and 'sales' are properties of the data object.
     *   chart.tooltip.content = '{country}, sales:{sales}';
     * </pre>
     *
     * The next example shows how to set the tooltip content using a function.
     *
     *  <pre>
     *   // Set the tooltip content
     *   chart.tooltip.content = function (ht) {
     *     return ht.name + ":" + ht.value.toFixed();
     *   }
     * </pre>
     */
    content: any;
    /**
     * Gets or sets the maximum distance from the element to display the tooltip.
     */
    threshold: number;
}
/**
 * Specifies the chart type.
 */
export declare enum ChartType {
    /** Shows vertical bars and allows you to compare values of items across categories. */
    Column = 0,
    /** Shows horizontal bars. */
    Bar = 1,
    /** Shows patterns within the data using X and Y coordinates. */
    Scatter = 2,
    /** Shows trends over a period of time or across categories. */
    Line = 3,
    /** Shows line chart with a symbol on each data point. */
    LineSymbols = 4,
    /** Shows line chart with the area below the line filled with color. */
    Area = 5,
    /** Shows Scatter chart with a third data value that determines the
     * size of the symbol. The data for this chart type can be defined using the
     *  @see:FlexChart or @see:Series <b>binding</b> property as a comma separated value in the
     * following format: "yProperty, bubbleSizeProperty".*/
    Bubble = 6,
    /** Presents items with high, low, open, and close values.
     * The size of the wick line is determined by the High and Low values,
     * while the size of the bar is determined by the Open and Close values.
     * The bar is displayed using different colors, depending on
     * whether the close value is higher or lower than the open value.
     * The data for this chart type can be defined using the
     *  @see:FlexChart or @see:Series <b>binding</b> property as a comma separated value in the
     * following format: "highProperty, lowProperty, openProperty, closeProperty". */
    Candlestick = 7,
    /** Displays the same information as a candlestick chart, except that opening
     * values are displayed using lines to the left, while lines to the right
     * indicate closing values.  The data for this chart type can be defined using the
     *  @see:FlexChart or @see:Series <b>binding</b> property as a comma separated value in the
     * following format: "highProperty, lowProperty, openProperty, closeProperty". */
    HighLowOpenClose = 8,
    /** Displays line chart that plots curves rather than angled lines through the
    * data points. */
    Spline = 9,
    /** Displays spline chart with symbols on each data point. */
    SplineSymbols = 10,
    /** Displays spline chart with the area below the line filled with color. */
    SplineArea = 11,
    /** Displays funnel chart.*/
    Funnel = 12,
    /** Displays Box & Whisker chart.*/
    BoxPlot = 13,
}
/**
 * The @see:FlexChart control provides a powerful and flexible way to visualize
 * data.
 *
 * You can use the @see:FlexChart control to create charts that display data in
 * several formats, including bar, line, symbol, bubble, and others.
 *
 * To use the @see:FlexChart control, set the @see:FlexChart.itemsSource property
 * to an array containing the data objects, then add one or more @see:Series objects
 * to the @see:FlexChart.series property.
 *
 * Use the @see:FlexChart.chartType property to define the @see:ChartType used as
 * a default for all series. You may override the chart type for each series by
 * setting the @see:Series.chartType property on the members of the
 * @see:FlexChart.series array.
 */
export declare class FlexChart extends FlexChartCore {
    private _chartType;
    /**
     * Initializes a new instance of the @see:FlexChart class.
     *
     * @param element The DOM element that will host the control,
     * or a selector for the host element (e.g. '#theCtrl').
     * @param options A JavaScript object containing initialization data
     * for the control.
     */
    constructor(element: any, options?: any);
    _getChartType(): ChartType;
    /**
     * Gets or sets the type of chart to create.
     */
    chartType: ChartType;
    /**
     * Gets or sets a value indicating whether to flip the axes so that
     * X is vertical and Y is horizontal.
     */
    rotated: boolean;
    /**
     * Gets or sets a value that determines whether and how the series objects are stacked.
     */
    stacking: Stacking;
    /**
     * Gets or sets various chart options.
     *
     * The following options are supported:
     *
     * <b>bubble.maxSize</b>: Specifies the maximum size
     * of symbols in the Bubble chart. The default value is 30 pixels.
     *
     * <b>bubble.minSize</b>: Specifies the minimum size
     * of symbols in the Bubble chart. The default value is 5 pixels.
     *
     * <pre>chart.options = {
     *   bubble: { minSize: 5, maxSize: 30 }
     * }</pre>
     *
     *
     * <b>funnel.neckWidth</b>: Specifies the neck width as a percentage for the Funnel chart.
     * The default value is 0.2.
     *
     * <b>funnel.neckHeight</b>: Specifies the neck height as a percentage for the Funnel chart.
     * The default value is 0.
     *
     * <b>funnel.type</b>: Specifies the type of Funnel chart. It should be 'rectangle' or 'default'.
     * neckWidth and neckHeight don't work if type is set to rectangle.
     *
     * <pre>chart.options = {
     *   funnel: { neckWidth: 0.3, neckHeight: 0.3, type: 'rectangle' }
     * }</pre>

     * <b>boxPlot.groupWidth</b>: Specifies the group width as a percentage for the Box&Whisker chart.
     * The default value is 0.8.
     *
     * <b>boxPlot.gapWidth</b>: Specifies the gap width as a percentage for the Box&Whisker chart.
     * The default value is 0.1.
     *
     * <b>boxPlot.showMeanLine</b>: Specifies whether to show the mean line for the Box&Whisker chart.
     * The default value is false.
     *
     * <b>boxPlot.meanLineStyle</b>: Specifies the style for the mean line.
     *
     * <b>boxPlot.showMeanMarker</b>: Specifies whether to show the mean marker for the Box&Whisker chart.
     * The default value is false.
     *
     * <b>boxPlot.showInnerPoints</b>: Specifies whether to show the inner points for the Box&Whisker chart.
     * The default value is false.
     *
     * <b>boxPlot.showOutliers</b>: Specifies whether to show the outliers for the Box&Whisker chart.
     * The default value is false.
     *
     * <b>boxPlot.meanMarkerStyle</b>: Specifies the style for the mean marker.

     * <b>boxPlot.quartileCalculation</b>: Specifies the quartile calculation for the Box&Whisker chart.
     *  It should be 'include' or 'exclude' for Inclusive Median and Exclusive Median.
     *
     * <pre>chart.options = {
     *   boxPlot: { groupWidth: 0.5, neckHeight: 0.3, showMeanMarker: true, showMeanLine: true }
     * }</pre>

     * <b>groupWidth</b>: Specifies the group width for the Column charts,
     * or the group height for the Bar charts. The group width can be specified
     * in pixels or as percentage of the available space. The default value is '70%'.
     *
     * <pre>chart.options = {
     *   groupWidth : 50; // 50 pixels
     * }
     * chart.options = {
     *   groupWidth : '100%'; // 100% pixels
     * }</pre>
     */
    options: any;
}
/**
 * Specifies the position of an axis or legend on the chart.
 */
export declare enum Position {
    /** The item is not visible. */
    None = 0,
    /** The item appears to the left of the chart. */
    Left = 1,
    /** The item appears above the chart. */
    Top = 2,
    /** The item appears to the right of the chart. */
    Right = 3,
    /** The item appears below the chart. */
    Bottom = 4,
    /** The item is positioned automatically. */
    Auto = 5,
}
/**
 * Specifies the axis type.
 */
export declare enum AxisType {
    /** Category axis (normally horizontal). */
    X = 0,
    /** Value axis (normally vertical). */
    Y = 1,
}
/**
 * Specifies how to handle overlapping labels.
 */
export declare enum OverlappingLabels {
    /**
     * Hide overlapping labels.
     */
    Auto = 0,
    /**
     * Show all labels, including overlapping ones.
     */
    Show = 1,
}
/**
 * Axis interface.
 */
export interface _IAxis {
    actualMin: number;
    actualMax: number;
    convert(val: number): number;
}
/**
 * Specifies whether and where the axis tick marks appear.
 */
export declare enum TickMark {
    /** No tick marks appear. */
    None = 0,
    /** Tick marks appear outside the plot area. */
    Outside = 1,
    /** Tick marks appear inside the plot area. */
    Inside = 2,
    /** Tick marks cross the axis. */
    Cross = 3,
}
/**
 * Represents an axis in the chart.
 */
export declare class Axis implements _IAxis {
    _GRIDLINE_WIDTH: number;
    _LINE_WIDTH: number;
    _TICK_WIDTH: number;
    _TICK_HEIGHT: number;
    _TICK_OVERLAP: number;
    _TICK_LABEL_DISTANCE: number;
    private static MAX_MAJOR;
    private static MAX_MINOR;
    _chart: FlexChartCore;
    private _type;
    private _min;
    private _max;
    private _position;
    private _majorUnit;
    private _minorUnit;
    private _majorGrid;
    private _minorGrid;
    private _title;
    private _labelStyle;
    private _reversed;
    private _format;
    private _actualMin;
    private _actualMax;
    _axisType: AxisType;
    private _majorTickMarks;
    private _minorTickMarks;
    private _logBase;
    private _labels;
    private _labelAngle;
    private _labelAlign;
    private _axisLine;
    _plotrect: wjcCore.Rect;
    private _szTitle;
    _isTimeAxis: boolean;
    _lbls: string[];
    _values: number[];
    private _rects;
    private _name;
    private _origin;
    private _overlap;
    private _items;
    private _cv;
    private _binding;
    private _ifmt;
    private _tfmt;
    private static _id;
    private __uniqueId;
    private _parea;
    private _labelPadding;
    _axrect: wjcCore.Rect;
    _desiredSize: wjcCore.Size;
    _annoSize: wjcCore.Size;
    _hasOrigin: boolean;
    _hostElement: SVGGElement;
    _vals: any;
    /**
     * Initializes a new instance of the @see:Axis class.
     *
     * @param position The position of the axis on the chart.
     */
    constructor(position?: Position);
    /**
     * Gets the axis host element.
     */
    hostElement: SVGGElement;
    /**
     * Gets the actual axis minimum.
     *
     * It returns a number or a Date object (for time-based data).
    */
    actualMin: any;
    /**
    * Gets the actual axis maximum.
    *
    * It returns a number or a Date object (for time-based data).
    */
    actualMax: any;
    /**
     * Gets or sets the minimum value shown on the axis.
     *
     * If not set, the minimum is calculated automatically.
     * The value can be a number or a Date object (for time-based data).
     */
    min: any;
    /**
     * Gets or sets the maximum value shown on the axis.
     *
     * If not set, the maximum is calculated automatically.
     * The value can be a number or a Date object (for time-based data).
     */
    max: any;
    /**
     * Gets or sets a value indicating whether the axis is
     * reversed (top to bottom or right to left).
     */
    reversed: boolean;
    /**
    * Gets or sets the enumerated axis position.
    */
    position: Position;
    /**
     * Gets or sets the number of units between axis labels.
     *
     * If the axis contains date values, then the units are
     * expressed in days.
     */
    majorUnit: number;
    /**
      * Gets or sets the number of units between minor axis ticks.
      *
      * If the axis contains date values, then the units are
      * expressed in days.
      */
    minorUnit: number;
    /**
     * Gets or sets the axis name.
     */
    name: string;
    /**
     * Gets or sets the title text shown next to the axis.
     */
    title: string;
    /**
     * Gets or sets the format string used for the axis labels
     * (see @see:Globalize).
     */
    format: string;
    /**
     * Gets or sets a value indicating whether the axis includes grid lines.
     */
    majorGrid: boolean;
    /**
     * Gets or sets the location of the axis tick marks.
     */
    majorTickMarks: TickMark;
    /**
     * Gets or sets a value indicating whether the axis includes minor grid lines.
     */
    minorGrid: boolean;
    /**
     * Gets or sets the location of the minor axis tick marks.
     */
    minorTickMarks: TickMark;
    /**
     * Gets or sets a value indicating whether the axis line is visible.
     */
    axisLine: boolean;
    /**
     * Gets or sets a value indicating whether the axis labels are visible.
     */
    labels: boolean;
    /**
     * Gets or sets the label alignment.
     *
     * By default the labels are centered. The supported values are 'left' and 'right
     * for x-axis and 'top' and 'bottom' for y-axis.
     */
    labelAlign: string;
    /**
     * Gets or sets the rotation angle of the axis labels.
     *
     * The angle is measured in degrees with valid values
     * ranging from -90 to 90.
     */
    labelAngle: number;
    /**
     * Gets or sets the value at which an axis crosses the perpendicular axis.
     **/
    origin: number;
    /**
     * Gets or sets a value indicating how to handle the overlapping axis labels.
     */
    overlappingLabels: OverlappingLabels;
    /**
     * Gets or sets the items source for the axis labels.
     *
     * Names of the properties are specified by the @see:wijmo.chart.Axis.binding.
     *
     * For example:
     *
     * <pre>
     *  // default value for Axis.binding is 'value,text'
     *  chart.axisX.itemsSource = [ { value:1, text:'one' }, { value:2, text:'two' } ];
     * </pre>
     */
    itemsSource: any;
    /**
     * Gets or sets the comma-separated property names for the
     * @see:wijmo.chart.Axis.itemsSource property to use in axis labels.
     *
     * The first name specifies the value on the axis, the second represents the corresponding
     * axis label. The default value is 'value,text'.
     */
    binding: string;
    /**
     * Gets or sets the itemFormatter function for the axis labels.
     *
     * If specified, the function takes two parameters:
     * <ul>
     * <li><b>render engine</b>: The @see:wijmo.chart.IRenderEngine object to be used
     * in formatting the labels.</li>
     * <li><b>current label</b>: A string value with the following properties:
     *   <ul>
     *     <li><b>value</b>: The value of the axis label to format.</li>
     *     <li><b>text</b>: The text to use in the label.</li>
     *     <li><b>pos</b>: The position in control coordinates at which
     *     the label is to be rendered.</li>
     *     <li><b>cls</b>: The CSS class to be applied to the label.</li>
     *   </ul></li>
     * </ul>
     *
     * The function returns the label parameters of labels for which
     * properties are modified.
     *
     * For example:
     * <pre>
     * chart.axisY.itemFormatter = function(engine, label) {
     *     if (label.val &gt; 5){
     *         engine.textFill = 'red'; // red text
     *         label.cls = null; // no default CSS
     *      }
     *     return label;
     * }
     * </pre>
     */
    itemFormatter: Function;
    /**
     * Gets or sets the logarithmic base of the axis.
     *
     * If the base is not specified the axis uses a linear scale.
     *
     * Use the @see:logBase property to spread data that is clustered
     * around the origin. This is common in several financial and economic
     * data sets.
     */
    logBase: number;
    /**
     * Gets or sets the plot area for the axis.
     */
    plotArea: PlotArea;
    /**
     * Gets or sets the label padding.
     */
    labelPadding: number;
    /**
     * Occurs when the axis range changes.
     */
    rangeChanged: wjcCore.Event;
    /**
     * Raises the @see:rangeChanged event.
     */
    onRangeChanged(e?: wjcCore.EventArgs): void;
    _isOverlapped(engine: IRenderEngine, w: number, lblClass: string): boolean;
    _actualAngle: number;
    /**
     * Calculates the axis height.
     *
     * @param engine Rendering engine.
     * @param maxw Max width.
     */
    _getHeight(engine: IRenderEngine, maxw: number): number;
    _updateAutoFormat(delta: number): number;
    _updateActualLimitsByChartType(labels: any, min: any, max: any): {
        min: any;
        max: any;
    };
    /**
     * Update the actual axis limits based on a specified data range.
     *
     * @param dataType Data type.
     * @param dataMin Data minimum.
     * @param dataMax Data maximum.
     * @param labels Category labels(category axis).
     * @param values Values(value axis).
     */
    _updateActualLimits(dataType: wjcCore.DataType, dataMin: number, dataMax: number, labels?: string[], values?: number[]): void;
    /**
     * Set the axis position.
     *
     * @param axisRect Axis rectangle.
     * @param plotRect Plot area rectangle.
     */
    _layout(axisRect: wjcCore.Rect, plotRect: wjcCore.Rect): void;
    /**
     * Render the axis.
     *
     * @param engine Rendering engine.
     */
    _render(engine: IRenderEngine): void;
    _renderLineAndTitle(engine: any): void;
    _renderMinor(engine: any, vals: any, isCategory: any): void;
    _renderLabelsAndTicks(engine: any, index: any, val: any, sval: any, labelAngle: any, tickMarks: any, showLabel: any, t1: any, t2: any): boolean;
    _xCross(x: number): boolean;
    _createMinors(engine: IRenderEngine, vals: number[], isVert: boolean, isNear: boolean, isCategory: boolean): void;
    _renderMinors(engine: IRenderEngine, ticks: number[], isVert: boolean, isNear: boolean): void;
    _renderLabel(engine: IRenderEngine, val: number, text: string, pos: wjcCore.Point, ha: any, va: any, className?: string): boolean;
    private _renderRotatedLabel(engine, sval, lpt, labelAngle, lblClass, isNear);
    private _getLabelAlign(isVert);
    _customConvert: Function;
    _customConvertBack: Function;
    /**
     * Converts the specified value from data to pixel coordinates.
     *
     * @param val The data value to convert.
     * @param maxValue The max value of the data, it's optional.
     * @param minValue The min value of the data, it's optional.
     */
    convert(val: number, maxValue?: number, minValue?: number): number;
    /**
     * Converts the specified value from pixel to data coordinates.
     *
     * @param val The pixel coordinates to convert back.
     */
    convertBack(val: number): number;
    /**
     * Gets the axis type.
     */
    axisType: AxisType;
    _getMinNum(): number;
    _getMaxNum(): number;
    private _invalidate();
    private _cvCollectionChanged(sender, e);
    private _createLabels(start, len, delta, vals, lbls);
    private _createLogarithmicLabels(min, max, unit, vals, lbls, isLabels);
    _createTimeLabels(start: number, len: number, vals: number[], lbls: string[]): void;
    _formatValue(val: number): string;
    private _calcMajorUnit();
    private _getAnnoNumber(isVert);
    private _nicePrecision(range);
    private _niceTickNumber(x);
    private _niceNumber(x, exp, round);
    _uniqueId: number;
}
/**
 * Represents a collection of @see:Axis objects in a @see:FlexChart control.
 */
export declare class AxisCollection extends wjcCore.ObservableArray {
    /**
     * Gets an axis by name.
     *
     * @param name The name of the axis to look for.
     * @return The axis object with the specified name, or null if not found.
     */
    getAxis(name: string): Axis;
    /**
     * Gets the index of an axis by name.
     *
     * @param name The name of the axis to look for.
     * @return The index of the axis with the specified name, or -1 if not found.
     */
    indexOf(name: string): number;
}
/**
 * Represents a plot area on the chart.
 *
 * The chart can have multiple plot areas with multiple axes.
 * To assign axis to plot area use <b>Axis.plotArea</b> property. For example:
 * <pre>
 *  // create a plot area
 *  var pa = new wijmo.chart.PlotArea();
 *  pa.row = 1;
 *  chart.plotAreas.push(pa);
 *  // create auxiliary y-axis
 *  var ay2 = new wijmo.chart.Axis(wijmo.chart.Position.Left);
 *  ay2.plotArea = pa; // attach axis to the plot area
 *  chart.axes.push(ay2);
 *  // plot first series along y-axis
 *  chart.series[0].axisY = ay2;
 * </pre>
 */
export declare class PlotArea {
    private _row;
    private _col;
    private _width;
    private _height;
    private _name;
    private _style;
    private _rect;
    _chart: FlexChartCore;
    /**
     * Initializes a new instance of the @see:PlotArea class.
     */
    constructor();
    /**
     * Gets or sets the row number of plot area.
     * Using <b>row</b> property, you can set horizontal position of the plot area
     * on the chart.
     */
    row: number;
    /**
     * Gets or sets the column number of plot area.
     * Using <b>column</b> property, you can set vertical position of the plot
     * area on the chart.
     */
    column: number;
    /**
     * Gets or sets the plot area name.
     */
    name: string;
    /**
     * Gets or sets width of the plot area.
     *
     * The width can be specified as number(sets the width in pixels) or
     * string in the format '{number}*' (star sizing).
     */
    width: any;
    /**
     * Gets or sets height of the plot area.
     *
     * The height can be specified as number(sets the height in pixels) or
     * string in the format '{number}*' (star sizing).
     */
    height: any;
    /**
     * Gets or sets the style of the plot area.
     *
     * Using <b>style</b> property, you can set appearance of the plot area.
     * For example:
     * <pre>
     *   pa.style = { fill: 'rgba(0,255,0,0.1)' };
     * </pre>
     */
    style: any;
    private _invalidate();
    _render(engine: IRenderEngine): void;
    _setPlotX(x: number, w: number): void;
    _setPlotY(y: number, h: number): void;
}
/**
 * Represents a collection of @see:PlotArea objects in a @see:FlexChartCore control.
 */
export declare class PlotAreaCollection extends wjcCore.ObservableArray {
    /**
     * Gets a plot area by name.
     *
     * @param name The name of the plot area to look for.
     * @return The axis object with the specified name, or null if not found.
     */
    getPlotArea(name: string): PlotArea;
    /**
     * Gets the index of a plot area by name.
     *
     * @param name The name of the plot area to look for.
     * @return The index of the plot area with the specified name, or -1 if not found.
     */
    indexOf(name: string): number;
    _getWidth(column: number): any;
    _getHeight(row: number): any;
    _calculateWidths(width: number, ncols: number): number[];
    _calculateHeights(height: number, nrows: number): number[];
    private _calculateLengths(width, ncols, glens);
}
/**
 * Specifies whether and where the Series is visible.
 */
export declare enum SeriesVisibility {
    /** The series is visible on the plot and in the legend. */
    Visible = 0,
    /** The series is visible only on the plot. */
    Plot = 1,
    /** The series is visible only in the legend. */
    Legend = 2,
    /** The series is hidden. */
    Hidden = 3,
}
/**
 * Specifies the type of marker to use for the @see:Series.symbolMarker
 * property.
 *
 * Applies to Scatter, LineSymbols, and SplineSymbols chart types.
 */
export declare enum Marker {
    /**
     * Uses a circle to mark each data point.
     */
    Dot = 0,
    /**
     * Uses a square to mark each data point.
     */
    Box = 1,
}
/**
 * Data series interface
 */
export interface _ISeries {
    style: any;
    symbolStyle: any;
    getValues: (dim: number) => number[];
    getDataType: (dim: number) => wjcCore.DataType;
    drawLegendItem(engine: IRenderEngine, rect: wjcCore.Rect, index: number): any;
    measureLegendItem(engine: IRenderEngine, index: number): wjcCore.Size;
    _setPointIndex(pointIndex: number, elementIndex: number): any;
}
/**
 * Provides arguments for @see:Series events.
 */
export declare class SeriesEventArgs extends wjcCore.EventArgs {
    _series: Series;
    /**
     * Initializes a new instance of the @see:SeriesEventArgs class.
     *
     * @param series Specifies the @see:Series object affected by this event.
     */
    constructor(series: SeriesBase);
    /**
     * Gets the @see:Series object affected by this event.
     */
    series: SeriesBase;
}
/**
 * Represents a series of data points to display in the chart.
 *
 */
export declare class SeriesBase implements _ISeries {
    static _LEGEND_ITEM_WIDTH: number;
    static _LEGEND_ITEM_HEIGHT: number;
    static _LEGEND_ITEM_MARGIN: number;
    private static _DEFAULT_SYM_SIZE;
    _chart: FlexChartCore;
    private _name;
    private _binding;
    private _showValues;
    private _symbolStyle;
    private _symbolSize;
    private _style;
    private _altStyle;
    private _cv;
    private _itemsSource;
    private _values;
    private _valueDataType;
    _chartType: ChartType;
    private _symbolMarker;
    private _bindingX;
    private _xvalues;
    private _xvalueDataType;
    private _cssClass;
    private _visibility;
    private _axisX;
    private _axisY;
    _legendElement: SVGAElement;
    _hostElement: SVGGElement;
    _pointIndexes: number[];
    constructor();
    /**
     * Gets or sets the series style.
     */
    style: any;
    /**
     * Gets or sets the alternative style for the series. The values from
     * this property will be used for negative values in Bar, Column,
     * and Scatter charts; and for rising values in financial chart types
     * like Candlestick, LineBreak, EquiVolume etc.
     *
     * If no value is provided, the default styles will be used.
     */
    altStyle: any;
    /**
     * Gets or sets the series symbol style.
     * Applies to Scatter, LineSymbols, and SplineSymbols chart types.
     */
    symbolStyle: any;
    /**
     * Gets or sets the size(in pixels) of the symbols used to render this @see:Series.
     * Applies to Scatter, LineSymbols, and SplineSymbols chart types.
     */
    symbolSize: number;
    _getSymbolSize(): number;
    /**
     * Gets or sets the shape of marker to use for each data point in the series.
     * Applies to Scatter, LineSymbols, and SplineSymbols chart types.
     */
    symbolMarker: Marker;
    /**
     * Gets or sets the name of the property that contains Y values for the series.
     */
    binding: string;
    /**
     * Gets or sets the name of the property that contains X values for the series.
     */
    bindingX: string;
    /**
     * Gets or sets the series name.
     *
     * The series name is displayed in the chart legend. Any series without a name
     * does not appear in the legend.
     */
    name: string;
    /**
     * Gets or sets the array or @see:ICollectionView object that contains the series data.
     */
    itemsSource: any;
    /**
     * Gets the @see:ICollectionView object that contains the data for this series.
     */
    collectionView: wjcCore.ICollectionView;
    /**
     * Gets the @see:FlexChart object that owns this series.
     */
    chart: FlexChartCore;
    /**
     * Gets the series host element.
     */
    hostElement: SVGGElement;
    /**
     * Gets the series element in the legend.
     */
    legendElement: SVGGElement;
    /**
     * Gets or sets the series CSS class.
     */
    cssClass: string;
    /**
     * Gets or sets an enumerated value indicating whether and where the series appears.
     */
    visibility: SeriesVisibility;
    /**
     * Occurs when series is rendering.
     */
    rendering: wjcCore.Event;
    /**
     * Raises the @see:rendering event.
     *
     * @param engine The @see:IRenderEngine object used to render the series.
     */
    onRendering(engine: IRenderEngine): void;
    /**
     * Gets a @see:HitTestInfo object with information about the specified point.
     *
     * @param pt The point to investigate, in window coordinates.
     * @param y The Y coordinate of the point (if the first parameter is a number).
     */
    hitTest(pt: any, y?: number): HitTestInfo;
    /**
     * Gets the plot element that corresponds to the specified point index.
     *
     * @param pointIndex The index of the data point.
     */
    getPlotElement(pointIndex: number): any;
    /**
     * Gets or sets the x-axis for the series.
     */
    axisX: Axis;
    /**
     * Gets or sets the y-axis for the series.
     */
    axisY: Axis;
    getDataType(dim: number): wjcCore.DataType;
    getValues(dim: number): number[];
    /**
      * Draw a legend item at the specified position.
      *
      * @param engine The rendering engine to use.
      * @param rect The position of the legend item.
      * @param index Index of legend item(for series with multiple legend items).
      */
    drawLegendItem(engine: IRenderEngine, rect: wjcCore.Rect, index: number): void;
    /**
     * Measures height and width of the legend item.
     *
     * @param engine The rendering engine to use.
     * @param index Index of legend item(for series with multiple legend items).
     */
    measureLegendItem(engine: IRenderEngine, index: number): wjcCore.Size;
    /**
     * Returns number of series items in the legend.
     */
    legendItemLength(): number;
    /**
     * Returns series bounding rectangle in data coordinates.
     *
     * If getDataRect() returns null, the limits are calculated automatically based on the data values.
     */
    getDataRect(): wjcCore.Rect;
    _getChartType(): ChartType;
    /**
     * Clears any cached data values.
     */
    _clearValues(): void;
    _getBinding(index: number): string;
    _getBindingValues(index: number): number[];
    _getItem(pointIndex: number): any;
    _getLength(): number;
    _setPointIndex(pointIndex: number, elementIndex: number): void;
    private _getDataRect();
    _isCustomAxisX(): boolean;
    _isCustomAxisY(): boolean;
    _getAxisX(): Axis;
    _getAxisY(): Axis;
    _measureLegendItem(engine: IRenderEngine, text: string): wjcCore.Size;
    _drawFunnelLegendItem(engine: IRenderEngine, rect: wjcCore.Rect, index: number, style: any, symbolStyle: any): void;
    private _getFunnelLegendName(index);
    _drawLegendItem(engine: IRenderEngine, rect: wjcCore.Rect, chartType: ChartType, text: string, style: any, symbolStyle: any): void;
    private _cvCollectionChanged(sender, e);
    private _cvCurrentChanged(sender, e);
    private _bindValues(items, binding, isX?);
    _invalidate(): void;
    _indexToPoint(pointIndex: number): wjcCore.Point;
    _getSymbolFill(seriesIndex?: number): string;
    _getSymbolStroke(seriesIndex?: number): string;
    _getAltSymbolStroke(seriesIndex?: number): string;
    _getAltSymbolFill(seriesIndex?: number): string;
    _renderLabels(engine: IRenderEngine, smap: _IHitArea[], chart: FlexChartCore, lblAreas: _RectArea[]): void;
    _getLabelPoint(dataPoint: _DataPoint): wjcCore.Point;
    _renderLabel(engine: IRenderEngine, s: string, index: number, pos: LabelPosition, offset: number, pt: wjcCore.Point, line: boolean, marg: any): wjcCore.Rect;
}
/**
 * Represents a series of data points to display in the chart.
 *
 * The @see:Series class supports all basic chart types. You may define
 * a different chart type on each @see:Series object that you add to the
 * @see:FlexChart series collection. This overrides the @see:chartType
 * property set on the chart that is the default for all @see:Series objects
 * in its collection.
 */
export declare class Series extends SeriesBase {
    /**
     * Gets or sets the chart type for a specific series, overriding the chart type
     * set on the overall chart.
     */
    chartType: ChartType;
}
/**
 * Represents a rendering engine that performs the basic drawing routines.
 */
export interface IRenderEngine {
    /**
     * Clear the viewport and start the rendering cycle.
     */
    beginRender(): any;
    /**
     * Finish the rendering cycle.
     */
    endRender(): any;
    /**
     * Set the size of the viewport.
     *
     * @param w Viewport width.
     * @param h Viewport height.
     */
    setViewportSize(w: number, h: number): any;
    /**
     * Gets the rendered element.
     */
    element: Element;
    /**
     * Gets or sets the color used to fill the element.
     */
    fill: string;
    /**
     * Gets or sets the color used to outline the element.
     */
    stroke: string;
    /**
     * Gets or sets the thickness of the outline.
     */
    strokeWidth: number;
    /**
     * Gets or sets the text color.
     */
    textFill: string;
    /**
     * Gets or sets the font size for the text output.
     */
    fontSize: string;
    /**
     * Gets or sets the font family for the text output.
    */
    fontFamily: string;
    drawEllipse(cx: number, cy: number, rx: number, ry: number, className?: string, style?: any): any;
    drawRect(x: number, y: number, w: number, h: number, className?: string, style?: any, clipPath?: string): any;
    drawLine(x1: number, y1: number, x2: number, y2: number, className?: string, style?: any): any;
    drawLines(xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): any;
    drawSplines(xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): any;
    drawPolygon(xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): any;
    drawPieSegment(cx: number, cy: number, radius: number, startAngle: number, sweepAngle: number, className?: string, style?: any, clipPath?: string): any;
    drawDonutSegment(cx: number, cy: number, radius: number, innerRadius: number, startAngle: number, sweepAngle: number, className?: string, style?: any, clipPath?: string): any;
    drawString(s: string, pt: wjcCore.Point, className?: string, style?: any): any;
    drawStringRotated(label: string, pt: wjcCore.Point, center: wjcCore.Point, angle: number, className?: string, style?: any): any;
    drawImage(imageHref: string, x: number, y: number, w: number, h: number): any;
    measureString(s: string, className?: string, groupName?: string, style?: any): wjcCore.Size;
    startGroup(className?: string, clipPath?: string, createTransform?: boolean): any;
    endGroup(): any;
    addClipRect(clipRect: wjcCore.Rect, id: string): any;
}
/**
 * Render to svg.
 */
export declare class _SvgRenderEngine implements IRenderEngine {
    private static svgNS;
    private static xlinkNS;
    private _element;
    private _svg;
    private _text;
    private _textGroup;
    private _defs;
    private _fill;
    private _stroke;
    private _textFill;
    private _strokeWidth;
    private _fontSize;
    private _fontFamily;
    private _group;
    private _clipRect;
    private static _isff;
    constructor(element: HTMLElement);
    beginRender(): void;
    endRender(): void;
    setViewportSize(w: number, h: number): void;
    element: Element;
    fill: string;
    fontSize: string;
    fontFamily: string;
    stroke: string;
    strokeWidth: number;
    textFill: string;
    addClipRect(clipRect: wjcCore.Rect, id: string): void;
    drawEllipse(cx: number, cy: number, rx: number, ry: number, className?: string, style?: any): SVGElement;
    drawRect(x: number, y: number, w: number, h: number, className?: string, style?: any, clipPath?: string): SVGElement;
    drawLine(x1: number, y1: number, x2: number, y2: number, className?: string, style?: any): SVGElement;
    drawLines(xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): SVGElement;
    drawSplines(xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): SVGElement;
    drawPolygon(xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): SVGElement;
    drawPieSegment(cx: number, cy: number, r: number, startAngle: number, sweepAngle: number, className?: string, style?: any, clipPath?: string): SVGElement;
    drawDonutSegment(cx: number, cy: number, radius: number, innerRadius: number, startAngle: number, sweepAngle: number, className?: string, style?: any, clipPath?: string): SVGElement;
    drawString(s: string, pt: wjcCore.Point, className?: string, style?: any): SVGElement;
    drawStringRotated(s: string, pt: wjcCore.Point, center: wjcCore.Point, angle: number, className?: string, style?: any): SVGElement;
    measureString(s: string, className?: string, groupName?: string, style?: any): wjcCore.Size;
    startGroup(className?: string, clipPath?: string, createTransform?: boolean): SVGElement;
    endGroup(): void;
    drawImage(imageHref: string, x: number, y: number, w: number, h: number): SVGElement;
    private _appendChild(element);
    private _create();
    private _setText(element, s);
    private _createText(pos, text);
    private _applyStyle(el, style);
    private _deCase(s);
    private _getBBox(text);
}
/**
 * Represents the chart legend.
 */
export declare class Legend {
    _chart: FlexChartBase;
    _position: Position;
    private _areas;
    private _sz;
    constructor(chart: FlexChartBase);
    /**
     * Gets or sets the enumerated value that determines whether and where the
     * legend appears in relation to the chart.
     */
    position: Position;
    _getDesiredSize(engine: IRenderEngine, pos: Position, w: number, h: number): wjcCore.Size;
    private _getDesiredSizeSeriesChart(engine, isVertical, w, h);
    private _renderSeriesChart(engine, pos, isVertical, w, h);
    private _getDesiredSizePieChart(engine, isVertical);
    private _renderPieChart(engine, pos, isVertical);
    _getPosition(w: number, h: number): Position;
    _render(engine: IRenderEngine, pt: wjcCore.Point, pos: Position, w: number, h: number): any;
    _hitTest(pt: wjcCore.Point): number;
}
/**
 * Specifies the type of chart element found by the hitTest method.
 */
export declare enum ChartElement {
    /** The area within the axes. */
    PlotArea = 0,
    /** X-axis. */
    AxisX = 1,
    /** Y-axis. */
    AxisY = 2,
    /** The area within the control but outside the axes. */
    ChartArea = 3,
    /** The chart legend. */
    Legend = 4,
    /** The chart header. */
    Header = 5,
    /** The chart footer. */
    Footer = 6,
    /** A chart series. */
    Series = 7,
    /** A chart series symbol. */
    SeriesSymbol = 8,
    /** A data label. */
    DataLabel = 9,
    /** No chart element. */
    None = 10,
}
/**
 * Contains information about a part of a @see:FlexChart control at
 * a specified page coordinate.
 */
export declare class HitTestInfo {
    private _chart;
    private _pt;
    private _series;
    private _pointIndex;
    _chartElement: ChartElement;
    _dist: number;
    private _item;
    private _x;
    private __xfmt;
    private _y;
    private __yfmt;
    private _name;
    /**
     * Initializes a new instance of the @see:HitTestInfo class.
     *
     * @param chart The chart control.
     * @param point The original point in window coordinates.
     * @param element The chart element.
     */
    constructor(chart: FlexChartBase, point: wjcCore.Point, element?: ChartElement);
    /**
     * Gets the point in control coordinates to which this HitTestInfo object
     * refers to.
     */
    point: wjcCore.Point;
    /**
     * Gets the chart series at the specified coordinates.
     */
    series: SeriesBase;
    /**
     * Gets the data point index at the specified coordinates.
     */
    pointIndex: number;
    /**
     * Gets the chart element at the specified coordinates.
     */
    chartElement: ChartElement;
    /**
     * Gets the distance from the closest data point.
     */
    distance: number;
    /**
     * Gets the data object that corresponds to the closest data point.
     */
    item: any;
    /**
     * Gets the x-value of the closest data point.
     */
    x: any;
    /**
     * Gets the y-value of the closest data point.
     */
    y: any;
    value: any;
    name: any;
    _xfmt: any;
    _yfmt: any;
    _setData(series: SeriesBase, pi?: number): void;
    _setDataPoint(dataPoint: _DataPoint): void;
    private _getValue(index, formatted);
}
/**
 * These are predefined color palettes for chart @see:Series objects.
 *
 * To create custom color palettes, supply an array of strings or rgba values.
 *
 * You can specify palettes for @see:FlexChart and @see:FlexPie controls.
 * For example:
 *
 * <pre>chart.palette = Palettes.light;</pre>
 *
 * The following palettes are pre-defined:
 * <ul>
 *   <li>standard (default)</li>
 *   <li>cocoa</li>
 *   <li>coral</li>
 *   <li>dark</li>
 *   <li>highcontrast</li>
 *   <li>light</li>
 *   <li>midnight</li>
 *   <li>minimal</li>
 *   <li>modern</li>
 *   <li>organic</li>
 *   <li>slate</li>
 * </ul>
 */
export declare class Palettes {
    static standard: string[];
    static cocoa: string[];
    static coral: string[];
    static dark: string[];
    static highcontrast: string[];
    static light: string[];
    static midnight: string[];
    static modern: string[];
    static organic: string[];
    static slate: string[];
    static zen: string[];
    static cyborg: string[];
    static superhero: string[];
    static flatly: string[];
    static darkly: string[];
    static cerulan: string[];
}
/**
 * Calculates Spline curves.
 */
export declare class _Spline {
    private k;
    private _x;
    private _y;
    private _a;
    private _b;
    private _c;
    private _d;
    private _len;
    private m;
    constructor(x: number[], y: number[]);
    private calculatePoint(val);
    calculate(): {
        xs: any;
        ys: any;
    };
}
/**
 * Specifies the position of data labels on the chart.
 */
export declare enum LabelPosition {
    /** No data labels appear. */
    None = 0,
    /** The labels appear to the left of the data points. */
    Left = 1,
    /** The labels appear above the data points. */
    Top = 2,
    /** The labels appear to the right of the data points. */
    Right = 3,
    /** The labels appear below the data points. */
    Bottom = 4,
    /** The labels appear centered on the data points. */
    Center = 5,
}
/**
 * Specifies the position of data labels on the pie chart.
 */
export declare enum PieLabelPosition {
    /** No data labels. */
    None = 0,
    /** The label appears inside the pie slice. */
    Inside = 1,
    /** The item appears at the center of the pie slice. */
    Center = 2,
    /** The item appears outside the pie slice. */
    Outside = 3,
}
/**
 * Provides arguments for @see:DataLabel rendering event.
 */
export declare class DataLabelRenderEventArgs extends RenderEventArgs {
    private _ht;
    private _pt;
    private _text;
    /**
     * Initializes a new instance of the @see:DataLabelRenderEventArgs class.
     *
     * @param engine (@see:IRenderEngine) The rendering engine to use.
     * @param ht The hit test information.
     * @param pt The reference point.
     * @param text The label text.
     */
    constructor(engine: IRenderEngine, ht: HitTestInfo, pt: wjcCore.Point, text: string);
    /**
     * Gets or sets a value that indicates whether the event should be cancelled.
     */
    cancel: boolean;
    /**
     * Gets the point associated with the label in control coordinates.
     */
    point: wjcCore.Point;
    /**
     * Gets or sets the label text.
     */
    text: string;
    /**
     * Gets the hit test information.
     */
    hitTestInfo: HitTestInfo;
}
/**
* Represents the base abstract class for the @see:DataLabel and the @see:PieDataLabel classes.
*/
export declare class DataLabelBase {
    private _content;
    _chart: FlexChartBase;
    private _bdr;
    private _line;
    private _off;
    /**
     * Gets or sets the content of data labels.
     *
     * The content can be specified as a string or as a function that
     * takes @see:HitTestInfo object as a parameter.
     *
     * When the label content is a string, it can contain any of the following
     * parameters:
     *
     * <ul>
     *  <li><b>seriesName</b>: Name of the series that contains the data point (FlexChart only).</li>
     *  <li><b>pointIndex</b>: Index of the data point.</li>
     *  <li><b>value</b>: <b>Value</b> of the data point.</li>
     *  <li><b>x</b>: <b>x</b>-value of the data point (FlexChart only).</li>
     *  <li><b>y</b>: <b>y</b>-value of the data point (FlexChart only).</li>
     *  <li><b>name</b>: <b>Name</b> of the data point.</li>
     *  <li><b>propertyName</b>: any property of data object.</li>
     * </ul>
     *
     * The parameter must be enclosed in curly brackets, for example 'x={x}, y={y}'.
     *
     * In the following example, we show the y value of the data point in the labels.
     *
     * <pre>
     *  // Create a chart and show y data in labels positioned above the data point.
     *  var chart = new wijmo.chart.FlexChart('#theChart');
     *  chart.initialize({
     *      itemsSource: data,
     *      bindingX: 'country',
     *      series: [
     *          { name: 'Sales', binding: 'sales' },
     *          { name: 'Expenses', binding: 'expenses' },
     *          { name: 'Downloads', binding: 'downloads' }],
     *  });
     *  chart.dataLabel.position = "Top";
     *  chart.dataLabel.content = "{country} {seriesName}:{y}";
     * </pre>
     *
     * The next example shows how to set data label content using a function.
     *
     * <pre>
     *  // Set the data label content
     *  chart.dataLabel.content = function (ht) {
     *    return ht.name + ":" + ht.value.toFixed();
     *  }
     * </pre>
     *
     */
    content: any;
    /**
     * Gets or sets a value indicating whether the data labels have borders.
     */
    border: boolean;
    /**
     * Gets or sets the offset from label to the data point.
     */
    offset: number;
    /**
     * Gets or sets a value indicating whether to draw lines that connect
     * labels to the data points.
     */
    connectingLine: boolean;
    /**
     * Occurs before the rendering data label.
     */
    rendering: wjcCore.Event;
    /**
     * Raises the @see:rendering event.
     *
     * @param e The @see:DataLabelRenderEventArgs object used to render the label.
     */
    onRendering(e: DataLabelRenderEventArgs): boolean;
    _invalidate(): void;
}
/**
 * The point data label for FlexChart.
 */
export declare class DataLabel extends DataLabelBase {
    private _pos;
    /**
     * Gets or sets the position of the data labels.
     */
    position: LabelPosition;
}
/**
 * The point data label for FlexPie.
 */
export declare class PieDataLabel extends DataLabelBase {
    private _pos;
    /**
     * Gets or sets the position of the data labels.
     */
    position: PieLabelPosition;
}
/**
 * Specifies the line type for the LineMarker.
 */
export declare enum LineMarkerLines {
    /** Show no lines. */
    None = 0,
    /** Show a vertical line. */
    Vertical = 1,
    /** Show a horizontal line. */
    Horizontal = 2,
    /** Show both vertical and horizontal lines. */
    Both = 3,
}
/**
 * Specifies how the LineMarker interacts with the user.
 */
export declare enum LineMarkerInteraction {
    /** No interaction, the user specifies the position by clicking. */
    None = 0,
    /** The LineMarker moves with the pointer. */
    Move = 1,
    /** The LineMarker moves when the user drags the line. */
    Drag = 2,
}
/**
 * Specifies the alignment of the LineMarker.
 */
export declare enum LineMarkerAlignment {
    /**
     * The LineMarker alignment adjusts automatically so that it stays inside the
     * boundaries of the plot area. */
    Auto = 2,
    /** The LineMarker aligns to the right of the pointer. */
    Right = 0,
    /** The LineMarker aligns to the left of the pointer. */
    Left = 1,
    /** The LineMarker aligns to the bottom of the pointer. */
    Bottom = 4,
    /** The LineMarker aligns to the top of the pointer. */
    Top = 6,
}
/**
 * Represents an extension of the LineMarker for the FlexChart.
 *
 * The LineMarker consists of a text area with content reflecting data point
 * values, and an optional vertical or horizontal line (or both for a cross-hair
 * effect) positioned over the plot area. It can be static (interaction = None),
 * follow the mouse or touch position (interaction = Move), or move when the user
 * drags the line (interaction = Drag).
 * For example:
 * <pre>
 *   // create an interactive marker with a horizontal line and y-value
 *   var lm = new wijmo.chart.LineMarker($scope.ctx.chart, {
 *       lines: wijmo.chart.LineMarkerLines.Horizontal,
 *       interaction: wijmo.chart.LineMarkerInteraction.Move,
 *       alignment : wijmo.chart.LineMarkerAlignment.Top
 *   });
 *   lm.content = function (ht) {
 *       // show y-value
 *       return lm.y.toFixed(2);
 *   }
 * </pre>
 */
export declare class LineMarker {
    static _CSS_MARKER: string;
    static _CSS_MARKER_HLINE: string;
    static _CSS_MARKER_VLINE: string;
    static _CSS_MARKER_CONTENT: string;
    static _CSS_MARKER_CONTAINER: string;
    static _CSS_LINE_DRAGGABLE: string;
    static _CSS_TOUCH_DISABLED: string;
    private _chart;
    private _plot;
    private _marker;
    private _markerContainer;
    private _markerContent;
    private _dragEle;
    private _hLine;
    private _vLine;
    private _plotRect;
    private _targetPoint;
    private _wrapperMoveMarker;
    private _capturedEle;
    private _wrapperMousedown;
    private _wrapperMouseup;
    private _contentDragStartPoint;
    private _mouseDownCrossPoint;
    private _isVisible;
    private _horizontalPosition;
    private _verticalPosition;
    private _alignment;
    private _content;
    private _seriesIndex;
    private _lines;
    private _interaction;
    private _dragThreshold;
    private _dragContent;
    private _dragLines;
    /**
     * Initializes a new instance of the @see:LineMarker class.
     *
     * @param chart The chart on which the LineMarker appears.
     * @param options A JavaScript object containing initialization data for the control.
     */
    constructor(chart: FlexChartCore, options?: any);
    /**
     * Gets the @see:FlexChart object that owns the LineMarker.
     */
    chart: FlexChartCore;
    /**
     * Gets or sets the visibility of the LineMarker.
     */
    isVisible: boolean;
    /**
     * Gets or sets the index of the series in the chart in which the LineMarker appears.
     * This takes effect when the @see:interaction property is set to
     * wijmo.chart.LineMarkerInteraction.Move or wijmo.chart.LineMarkerInteraction.Drag.
     */
    seriesIndex: number;
    /**
     * Gets or sets the horizontal position of the LineMarker relative to the plot area.
     *
     * Its value range is (0, 1).
     * If the value is null or undefined and @see:interaction is set to
     * wijmo.chart.LineMarkerInteraction.Move or wijmo.chart.LineMarkerInteraction.Drag,
     * the horizontal position of the marker is calculated automatically based on the
     * pointer's position.
     */
    horizontalPosition: number;
    /**
     * Gets the current x-value as chart data coordinates.
     */
    x: number;
    /**
     * Gets the current y-value as chart data coordinates.
     */
    y: number;
    /**
     * Gets or sets the content function that allows you to customize the text content of the LineMarker.
     */
    content: Function;
    /**
     * Gets or sets the vertical position of the LineMarker relative to the plot area.
     *
     * Its value range is (0, 1).
     * If the value is null or undefined and @see:interaction is set to wijmo.chart.LineMarkerInteraction.Move
     * or wijmo.chart.LineMarkerInteraction.Drag, the vertical position of the LineMarker is calculated automatically based on the pointer's position.
     */
    verticalPosition: number;
    /**
     * Gets or sets the alignment of the LineMarker content.
     *
     * By default, the LineMarker shows to the right, at the bottom of the target point.
     * Use '|' to combine alignment values.
     *
     * <pre>
     * // set the alignment to the left.
     * marker.alignment = wijmo.chart.LineMarkerAlignment.Left;
     * // set the alignment to the left top.
     * marker.alignment = wijmo.chart.LineMarkerAlignment.Left | wijmo.chart.LineMarkerAlignment.Top;
     * </pre>
     */
    alignment: LineMarkerAlignment;
    /**
     * Gets or sets the visibility of the LineMarker lines.
     */
    lines: LineMarkerLines;
    /**
     * Gets or sets the interaction mode of the LineMarker.
     */
    interaction: LineMarkerInteraction;
    /**
        Gets or sets the maximum distance from the horizontal or vertical line that the marker can be dragged.
    */
    dragThreshold: number;
    /**
        Gets or sets a value indicating whether the content of the marker is draggable when the interaction mode is "Drag."
    */
    dragContent: boolean;
    /**
        Gets or sets a value indicating whether the lines are linked when the horizontal or vertical line is dragged when the interaction mode is "Drag."
    */
    dragLines: boolean;
    /**
     * Occurs after the LineMarker's position changes.
     */
    positionChanged: wjcCore.Event;
    /**
     * Raises the @see:positionChanged event.
     *
     * @param point The target point at which to show the LineMarker.
     */
    onPositionChanged(point: wjcCore.Point): void;
    /**
     * Removes the LineMarker from the chart.
     */
    remove(): void;
    private _attach();
    private _attachDrag();
    private _detach();
    private _detachDrag();
    private _toggleDragEventAttach(isAttach);
    private _onMousedown(e);
    private _onMouseup(e);
    _moveMarker(e: any): void;
    private _show(ele?);
    private _hide(ele?);
    private _toggleVisibility();
    private _resetDefaultValue();
    private _initialize();
    private _createMarker();
    private _removeMarker();
    private _getContainer();
    private _createContainer();
    private _createChildren();
    private _toggleElesDraggableClass(draggable);
    private _updateMarkerSize();
    private _updateLinesSize();
    private _resetLinesVisibility();
    private _updateMarkerPosition(point?);
    private _updateContent();
    private _raisePositionChanged(x, y);
    private _updatePositionByAlignment(isMarkerMoved?);
    private _getEventPoint(e);
    private _pointInRect(pt, rect);
}
export declare class _DataPoint {
    private _seriesIndex;
    private _pointIndex;
    private _dataX;
    private _dataY;
    constructor(seriesIndex: number, pointIndex: number, dataX: number, dataY: number);
    seriesIndex: number;
    pointIndex: number;
    dataX: number;
    dataY: number;
}
export declare enum _MeasureOption {
    X = 0,
    Y = 1,
    XY = 2,
}
export declare class _RectArea implements _IHitArea {
    private _rect;
    constructor(rect: wjcCore.Rect);
    rect: wjcCore.Rect;
    tag: any;
    contains(pt: wjcCore.Point): boolean;
    pointDistance(pt1: wjcCore.Point, pt2: wjcCore.Point, option: _MeasureOption): number;
    distance(pt: wjcCore.Point): number;
}
export declare class _CircleArea implements _IHitArea {
    private _center;
    private _rad;
    private _rad2;
    tag: any;
    constructor(center: wjcCore.Point, radius: number);
    setRadius(radius: number): void;
    center: wjcCore.Point;
    contains(pt: wjcCore.Point): boolean;
    distance(pt: wjcCore.Point): number;
}
export declare class _LinesArea implements _IHitArea {
    private _x;
    private _y;
    tag: any;
    constructor(x: any, y: any);
    contains(pt: wjcCore.Point): boolean;
    distance(pt: wjcCore.Point): number;
}
export declare class _HitResult {
    area: _IHitArea;
    distance: number;
}
export declare class _HitTester {
    _chart: FlexChartCore;
    _map: {
        [key: number]: Array<_IHitArea>;
    };
    constructor(chart: FlexChartCore);
    add(area: _IHitArea, seriesIndex: number): void;
    clear(): void;
    hitTest(pt: wjcCore.Point, testLines?: boolean): _HitResult;
    hitTestSeries(pt: wjcCore.Point, seriesIndex: any): _HitResult;
}
/**
 * Plots data series.
 */
export interface _IPlotter {
    chart: FlexChartCore;
    dataInfo: _DataInfo;
    hitTester: _HitTester;
    seriesIndex: number;
    seriesCount: number;
    clipping: boolean;
    stacking: Stacking;
    rotated: boolean;
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): any;
    load(): any;
    unload(): any;
}
/**
 * Base class for chart plotters of all types (bar, line, area).
 */
export declare class _BasePlotter {
    _DEFAULT_WIDTH: number;
    _DEFAULT_SYM_SIZE: number;
    clipping: boolean;
    chart: FlexChart;
    hitTester: _HitTester;
    dataInfo: _DataInfo;
    seriesIndex: number;
    seriesCount: number;
    clear(): void;
    getNumOption(name: string, parent?: string): number;
    static cloneStyle(style: any, ignore: string[]): any;
    isValid(datax: number, datay: number, ax: _IAxis, ay: _IAxis): boolean;
    load(): void;
    unload(): void;
}
/**
 * Bar/column chart plotter.
 */
export declare class _BarPlotter extends _BasePlotter implements _IPlotter {
    origin: number;
    width: number;
    isVolume: boolean;
    private _volHelper;
    private _itemsSource;
    stackPosMap: {};
    stackNegMap: {};
    stacking: wjcSelf.Stacking;
    rotated: boolean;
    _getSymbolOrigin: Function;
    _getSymbolStyles: Function;
    clear(): void;
    load(): void;
    unload(): void;
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): void;
    private drawSymbol(engine, rect, series, pointIndex, point);
    private drawDefaultSymbol(engine, rect, series);
}
/**
 * Box plotter.
 */
export declare class _BoxPlotter extends _BarPlotter {
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): void;
    convertPoints(points: number[], axis: _IAxis): number[];
    drawBoxWhisker(engine: IRenderEngine, xs: any, ys: any, series: _ISeries): void;
}
export declare class _BarPlot {
    private _data;
    private _min;
    private _max;
    private _mean;
    private _firstQuartile;
    private _thirdQuartile;
    private _median;
    private _quartileCalculation;
    private _firstHalfIndex;
    private _secondHalfIndex;
    private _iqr;
    private _outlierPoints;
    private _innerPoints;
    private _showOutliers;
    constructor(data: number[], quartileCalculation: string, showOutliers: boolean);
    min: number;
    max: number;
    mean: number;
    firstQuartile: number;
    thirdQuartile: number;
    median: number;
    outlierPoints: number[];
    innerPoints: number[];
    _parse(): void;
    _getMedianIndex(min: any, max: any): void;
    _getMedianValue(min: any, max: any): number;
}
/**
 * Line/scatter chart plotter.
 */
export declare class _LinePlotter extends _BasePlotter implements _IPlotter {
    hasSymbols: boolean;
    hasLines: boolean;
    isSpline: boolean;
    rotated: boolean;
    stacking: wjcSelf.Stacking;
    stackPos: {
        [key: number]: number;
    };
    stackNeg: {
        [key: number]: number;
    };
    constructor();
    clear(): void;
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): void;
    _drawLines(engine: IRenderEngine, xs: number[], ys: number[], className?: string, style?: any, clipPath?: string): void;
    _drawSymbol(engine: IRenderEngine, x: number, y: number, sz: number, series: SeriesBase, pointIndex: number): void;
    _drawDefaultSymbol(engine: IRenderEngine, x: number, y: number, sz: number, marker: Marker, style?: any): void;
}
/**
 * Area chart plotter.
 */
export declare class _AreaPlotter extends _BasePlotter implements _IPlotter {
    stacking: wjcSelf.Stacking;
    isSpline: boolean;
    rotated: boolean;
    private stackPos;
    private stackNeg;
    constructor();
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    clear(): void;
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): void;
    _convertToSpline(x: number[], y: number[]): {
        xs: any;
        ys: any;
    };
    _drawSymbols(engine: IRenderEngine, series: _ISeries, seriesIndex: number): void;
}
export declare class _BubblePlotter extends _LinePlotter {
    private _MIN_SIZE;
    private _MAX_SIZE;
    private _minSize;
    private _maxSize;
    private _minValue;
    private _maxValue;
    constructor();
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    _drawSymbol(engine: IRenderEngine, x: number, y: number, sz: number, series: Series, pointIndex: number): void;
}
export declare class _FinancePlotter extends _BasePlotter {
    isCandle: boolean;
    isArms: boolean;
    isEqui: boolean;
    isVolume: boolean;
    symbolWidth: any;
    private _volHelper;
    private _itemsSource;
    private _symWidth;
    private _isPixel;
    clear(): void;
    load(): void;
    unload(): void;
    parseSymbolWidth(val: any): void;
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): void;
    _drawSymbol(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, si: number, pi: number, fill: any, w: number, x: number, hi: number, lo: number, open: number, close: number): void;
}
/**
 * Funnel chart plotter.
 */
export declare class _FunnelPlotter extends _BasePlotter implements _IPlotter {
    _getSymbolOrigin: Function;
    _getSymbolStyles: Function;
    stacking: wjcSelf.Stacking;
    rotated: boolean;
    adjustLimits(dataInfo: _DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    plotSeries(engine: IRenderEngine, ax: _IAxis, ay: _IAxis, series: _ISeries, palette: _IPalette, iser: number, nser: number): void;
    private _getTrapezoidArea(width, angle, height);
    private _getTrapezoidOffsetY(width, area, angle);
    private drawSymbol(engine, rect, series, pointIndex, point);
    private drawDefaultSymbol(engine, rect, series);
}
export declare class _FunnelSegment implements _IHitArea {
    private _center;
    private _startPoint;
    private _width;
    private _height;
    private _neckWidth;
    private _neckHeight;
    private _offsetX;
    private _offsetY;
    constructor(startPoint: wjcCore.Point, width: number, height: number, neckWidth: number, neckHeight: number);
    contains(pt: wjcCore.Point): boolean;
    distance(pt: wjcCore.Point): number;
    center: wjcCore.Point;
    tag: any;
}
export declare class _VolumeHelper {
    private _volumes;
    private _xVals;
    private _xDataMin;
    private _xDataMax;
    private _xDataType;
    private _hasXs;
    private _calcData;
    constructor(volumes: number[], xVals: number[], xDataMin: number, xDataMax: number, xDataType?: wjcCore.DataType);
    convert(x: number, min: number, max: number): number;
    convertBack(x: number, min: number, max: number): number;
    private _init();
    private _getXVolume(x);
    static convertToRange(value: number, newMin: number, newMax: number, oldMin: number, oldMax: number): number;
    private _fillGaps();
}
