import * as wjcCore from 'wijmo/wijmo';
import * as wjcChart from 'wijmo/wijmo.chart';
/**
 * Represents a Fibonacci Retracements tool for the @see:FinancialChart.

 * The tool enables the calculation and plotting of various alert levels that are
 * useful in financial charts.
 *
 * To add Fibonacci tool to a @see:FinancialChart control, create an instance
 * of the @see:Fibonacci and add it to the <b>series</b> collection of the chart.
 * For example:
 *
 * <pre>
 * // create chart
 * var chart = new wijmo.chart.finance.FinancialChart('#chartElement');
 * // create Fibonacci tool
 * var ftool = new wijmo.chart.finance.analytics.Fibonacci();
 * chart.series.push(ftool);
 * </pre>
  */
export declare class Fibonacci extends wjcChart.SeriesBase {
    private _high;
    private _low;
    private _minX;
    private _maxX;
    private _actualHigh;
    private _actualLow;
    private _levels;
    private _uptrend;
    private _labelPosition;
    /**
     * Initializes a new instance of the @see:Fibonacci class.
     *
     * @param options A JavaScript object containing initialization data.
     */
    constructor(options?: any);
    /**
     * Gets or sets the low value of @see:Fibonacci tool.
     *
     * If not specified, the low value is calculated based on data values provided by <b>itemsSource</b>.
     */
    low: number;
    /**
     * Gets or sets the high value of @see:Fibonacci tool.
     *
     * If not specified, the high value is caclulated based on
     * data values provided by the <b>itemsSource</b>.
     */
    high: number;
    /**
     * Gets or sets the label position for levels in @see:Fibonacci tool.
     */
    labelPosition: wjcChart.LabelPosition;
    /**
     * Gets or sets a value indicating whether to create uptrending @see:Fibonacci tool.
     *
     * Default value is true(uptrend). If the value is false, the downtrending levels are plotted.
     */
    uptrend: boolean;
    /**
     * Gets or sets the array of levels for plotting.
     *
     * Default value is [0, 23.6, 38.2, 50, 61.8, 100].
     */
    levels: number[];
    /**
     * Gets or sets the x minimal value of the @see:Fibonacci tool.
     *
     * If not specified, current minimum of x-axis is used.
     * The value can be specified as a number or Date object.
     */
    minX: any;
    /**
     * Gets or sets the x maximum value of the @see:Fibonacci tool.
     *
     * If not specified, current maximum of x-axis is used.
     * The value can be specified as a number or Date object.
     */
    maxX: any;
    private _getMinX();
    private _getMaxX();
    private _updateLevels();
    private _render(sender, args);
    _getChartType(): wjcChart.ChartType;
}
/**
 * Represents a Fibonacci Arcs tool for the @see:FinancialChart.
 */
export declare class FibonacciArcs extends wjcChart.SeriesBase {
    private _start;
    private _end;
    private _levels;
    private _labelPosition;
    /**
     * Initializes a new instance of the @see:FibonacciArcs class.
     *
     * @param options A JavaScript object containing initialization data.
     */
    constructor(options?: any);
    /**
     * Gets or sets the starting @see:DataPoint for the base line.
     *
     * The @see:DataPoint x value can be a number or a Date object
     * (for time-based data).
     *
     * Unlike some of the other Fibonacci tools, the starting
     * @see:DataPoint is <b>not</b> calculated automatically if
     * undefined.
     */
    start: wjcChart.DataPoint;
    /**
     * Gets or sets the ending @see:DataPoint for the base line.
     *
     * The @see:DataPoint x value can be a number or a Date object
     * (for time-based data).
     *
     * Unlike some of the other Fibonacci tools, the ending
     * @see:DataPoint is <b>not</b> calculated automatically if
     * undefined.
     */
    end: wjcChart.DataPoint;
    /**
     * Gets or sets the array of levels for plotting.
     *
     * Default value is [38.2, 50, 61.8].
     */
    levels: number[];
    /**
     * Gets or sets the @see:LabelPosition for levels in @see:FibonacciArcs tool.
     */
    labelPosition: wjcChart.LabelPosition;
    _render(sender: wjcChart.SeriesBase, args: wjcChart.RenderEventArgs): void;
    private _getX(dim);
    private _getY(dim);
    _getChartType(): wjcChart.ChartType;
}
/**
 * Represents a Fibonacci Fans tool for the @see:FinancialChart.
 */
export declare class FibonacciFans extends wjcChart.SeriesBase {
    private _start;
    private _end;
    private _levels;
    private _labelPosition;
    /**
     * Initializes a new instance of the @see:FibonacciFans class.
     *
     * @param options A JavaScript object containing initialization data.
     */
    constructor(options?: any);
    /**
     * Gets or sets the starting @see:DataPoint for the base line.
     *
     * If not set, the starting @see:DataPoint is calculated automatically.
     * The @see:DataPoint x value can be a number or a Date object (for
     * time-based data).
     */
    start: wjcChart.DataPoint;
    /**
     * Gets or sets the ending @see:DataPoint for the base line.
     *
     * If not set, the starting @see:DataPoint is calculated automatically.
     * The @see:DataPoint x value can be a number or a Date object (for
     * time-based data).
     */
    end: wjcChart.DataPoint;
    /**
     * Gets or sets the array of levels for plotting.
     *
     * Default value is [0, 23.6, 38.2, 50, 61.8, 100].
     */
    levels: number[];
    /**
     * Gets or sets the @see:LabelPosition for levels in @see:FibonacciFans tool.
     */
    labelPosition: wjcChart.LabelPosition;
    _updateLevels(): void;
    _render(sender: wjcChart.SeriesBase, args: wjcChart.RenderEventArgs): void;
    private _getX(dim);
    private _getY(dim);
    _getChartType(): wjcChart.ChartType;
}
/**
 * Represents a Fibonacci Time Zones tool for the @see:FinancialChart.
 */
export declare class FibonacciTimeZones extends wjcChart.SeriesBase {
    private _startX;
    private _endX;
    private _levels;
    private _labelPosition;
    /**
     * Initializes a new instance of the @see:FibonacciTimeZones class.
     *
     * @param options A JavaScript object containing initialization data.
     */
    constructor(options?: any);
    /**
     * Gets or sets the starting X data point for the time zones.
     *
     * If not set, the starting X data point is calculated automatically. The
     * value can be a number or a Date object (for time-based data).
     */
    startX: any;
    /**
     * Gets or sets the ending X data point for the time zones.
     *
     * If not set, the ending X data point is calculated automatically. The
     * value can be a number or a Date object (for time-based data).
     */
    endX: any;
    /**
     * Gets or sets the array of levels for plotting.
     *
     * Default value is [0, 1, 2, 3, 5, 8, 13, 21, 34].
     */
    levels: number[];
    /**
     * Gets or sets the @see:LabelPosition for levels in @see:FibonacciTimeZones tool.
     */
    labelPosition: wjcChart.LabelPosition;
    _render(sender: wjcChart.SeriesBase, args: wjcChart.RenderEventArgs): void;
    _updateLevels(): void;
    private _getX(dim);
    _getChartType(): wjcChart.ChartType;
}
/**
 * Base class for overlay and indicator series (abstract).
 */
export declare class OverlayIndicatorBase extends wjcChart.SeriesBase {
    private __plotter;
    private __hitTester;
    _styles: any;
    _seriesCount: number;
    constructor();
    _plotter: wjcChart._IPlotter;
    _hitTester: wjcChart._HitTester;
    _getChartType(): wjcChart.ChartType;
    _getXValues(): number[];
    _getDataPoint(dataX: number, dataY: number, seriesIndex: number, pointIndex: number, ax: wjcChart.Axis, ay: wjcChart.Axis): wjcChart._DataPoint;
    _shouldCalculate(): boolean;
    _init(): void;
    _calculate(): void;
    _clearValues(): void;
    _getName(dim: number): string;
    _getStyles(dim: number): any;
    legendItemLength(): number;
    measureLegendItem(engine: wjcChart.IRenderEngine, index: number): wjcCore.Size;
    drawLegendItem(engine: wjcChart.IRenderEngine, rect: wjcCore.Rect, index: number): void;
}
/**
 * Base class for overlay and indicator series that render a single series (abstract).
 */
export declare class SingleOverlayIndicatorBase extends OverlayIndicatorBase {
    private _period;
    _xvals: number[];
    _yvals: number[];
    constructor();
    /**
     * Gets or sets the period for the calculation as an integer value.
     */
    period: any;
    getValues(dim: number): number[];
    getDataRect(): wjcCore.Rect;
    _clearValues(): void;
    _shouldCalculate(): boolean;
    _init(): void;
    _getItem(pointIndex: number): any;
}
/**
 * Represents an Average True Range indicator series for the @see:FinancialChart.
 *
 * Average true range is used to measure the volatility of an asset. Average true range
 * does not provide any indication of the price's trend, but rather the degree of price
 * volatility.
 */
export declare class ATR extends SingleOverlayIndicatorBase {
    constructor();
    _calculate(): void;
}
/**
 * Represents a Commodity Channel Index indicator series for the @see:FinancialChart.
 *
 * The commodity channel index is an oscillator that measures an asset's current price
 * level relative to an average price level over a specified period of time.
 */
export declare class CCI extends SingleOverlayIndicatorBase {
    private _constant;
    constructor();
    /**
     * Gets or sets the constant value for the CCI calculation.  The default
     * value is 0.015.
     */
    constant: number;
    _calculate(): void;
}
export declare function _cci(highs: number[], lows: number[], closes: number[], period: number, constant: number): number[];
/**
 * Represents a Willaims %R indicator series for the @see:FinancialChart.
 *
 * Williams %R is a momentum indicator that is the inverse of a fast stochastic
 * oscillator (@see:Stochastic).  The Williams %R indicator is designed to
 * tell whether an asset is trading near the high or low of its trading range.
 */
export declare class WilliamsR extends SingleOverlayIndicatorBase {
    constructor();
    _calculate(): void;
}
export declare function _williamsR(highs: number[], lows: number[], closes: number[], period: number): number[];
export declare enum MovingAverageType {
    Simple = 0,
    Exponential = 1,
}
/**
 * Represents a Moving Average Envelopes overlay series for the @see:FinancialChart.
 *
 * Moving average envelopes are moving averages set above and below a standard moving
 * average.  The amount above/below the standard moving average is percentage based and
 * dictated by the @see:size property.
 */
export declare class Envelopes extends OverlayIndicatorBase {
    private _upperYVals;
    private _lowerYVals;
    private _xVals;
    private _period;
    private _type;
    private _size;
    constructor();
    /**
     * Gets or sets the period for the calculation as an integer value.
     */
    period: any;
    /**
     * Gets or sets the moving average type for the
     * envelopes.  The default value is Simple.
     */
    type: MovingAverageType;
    /**
     * Gets or set the size of the moving average
     * envelopes.  The default value is 2.5 percent (0.025).
     */
    size: number;
    getDataRect(): wjcCore.Rect;
    _clearValues(): void;
    _init(): void;
    _shouldCalculate(): boolean;
    _calculate(): void;
    private _rendering(sender, args);
    getCalculatedValues(key: string): any[];
}
/**
 * Represents a Bollinger Bands&reg; overlay series for the @see:FinancialChart.
 *
 * <i>Bollinger Bands is a registered trademark of John Bollinger.</i>
 */
export declare class BollingerBands extends OverlayIndicatorBase {
    private _upperYVals;
    private _middleYVals;
    private _lowerYVals;
    private _xVals;
    private _period;
    private _multiplier;
    constructor();
    /**
     * Gets or sets the period for the calculation as an integer value.
     */
    period: any;
    /**
     * Gets or sets the standard deviation multiplier.
     */
    multiplier: number;
    getDataRect(): wjcCore.Rect;
    _clearValues(): void;
    _shouldCalculate(): boolean;
    _init(): void;
    _calculate(): void;
    private _rendering(sender, args);
    getCalculatedValues(key: string): any[];
}
export declare function _bollingerBands(ys: number[], period: number, multiplier: number): any;
/**
 * Represents a Relative Strength Index indicator series for the @see:FinancialChart.
 *
 * Relative strength index is a momentum osciallator designed to measure the current
 * and historical strength or weakness of an asset based on the closing prices of a
 * recent trading period.
 */
export declare class RSI extends SingleOverlayIndicatorBase {
    constructor();
    _calculate(): void;
}
export declare function _rsi(ys: number[], period: number): number[];
/**
 * Base class for @see:Macd and @see:MacdHistogram series (abstract).
 */
export declare class MacdBase extends OverlayIndicatorBase {
    _macdXVals: number[];
    _macdVals: number[];
    _signalXVals: number[];
    _signalVals: number[];
    _histogramXVals: number[];
    _histogramVals: number[];
    private _fastPeriod;
    private _slowPeriod;
    private _smoothingPeriod;
    constructor();
    /**
     * Gets or sets the fast exponential moving average period
     * for the MACD line.
     */
    fastPeriod: number;
    /**
     * Gets or sets the slow exponential moving average period
     * for the MACD line.
     */
    slowPeriod: number;
    /**
     * Gets or sets the exponential moving average period
     * for the signal line.
     */
    smoothingPeriod: number;
    _clearValues(): void;
    _shouldCalculate(): boolean;
    _init(): void;
    _calculate(): void;
}
/**
 * Represents a Moving Average Convergence/Divergence (MACD) indicator series
 * for the @see:FinancialChart.
 *
 * The MACD indicator is designed to reveal changes in strength, direction, momentum,
 * and duration of an asset's price trend.
 */
export declare class Macd extends MacdBase {
    constructor();
    /**
     * Gets or sets the styles for the MACD and Signal lines.
     *
     * The following options are supported:
     *
     * <pre>series.styles = {
     *   macdLine: {
     *      stroke: 'red',
     *      strokeWidth: 1
     *   },
     *   signalLine: {
     *      stroke: 'green',
     *      strokeWidth: 1
     *   },
     * }</pre>
     */
    styles: any;
    getDataRect(): wjcCore.Rect;
    private _rendering(sender, args);
    getCalculatedValues(key: string): any[];
}
/**
 * Represents a Moving Average Convergence/Divergence (MACD) Histogram indicator series
 * for the @see:FinancialChart.
 *
 * The MACD indicator is designed to reveal changes in strength, direction, momentum,
 * and duration of an asset's price trend.
 */
export declare class MacdHistogram extends MacdBase {
    constructor();
    getValues(dim: number): number[];
    getDataRect(): wjcCore.Rect;
    _getChartType(): wjcChart.ChartType;
    _getItem(pointIndex: number): any;
}
export declare function _macd(ys: number[], fastPeriod: number, slowPeriod: number, smoothingPeriod: number): any;
/**
 * Represents a Stochastic Oscillator indicator series for the @see:FinancialChart.
 *
 * Stochastic oscillators are momentum indicators designed to predict price turning
 * points by comparing an asset's closing price to its high-low range.
 *
 * The @see:Stochastic series can be used for fast (default), slow and full stochastic
 * oscillators.  To create a slow or full stochastic oscillator, set the @see:smoothingPeriod
 * to an integer value greater than one; slow stochastic oscillators generally use a fixed
 * @see:smoothingPeriod of three.  To create or revert to a fast stochastic oscillator, set the
 * @see:smoothingPeriod to an integer value of one.
 */
export declare class Stochastic extends OverlayIndicatorBase {
    private _kVals;
    private _kXVals;
    private _dVals;
    private _dXVals;
    private _kPeriod;
    private _dPeriod;
    private _smoothingPeriod;
    constructor();
    /**
     * Gets or sets the period for the %K calculation.
     */
    kPeriod: number;
    /**
     * Gets or sets the period for the %D simple moving average.
     */
    dPeriod: number;
    /**
     * Gets or sets the smoothing period for full %K.
     */
    smoothingPeriod: number;
    /**
     * Gets or sets the styles for the %K and %D lines.
     *
     * The following options are supported:
     *
     * <pre>series.styles = {
     *   kLine: {
     *      stroke: 'red',
     *      strokeWidth: 1
     *   },
     *   dLine: {
     *      stroke: 'green',
     *      strokeWidth: 1
     *   },
     * }</pre>
     */
    styles: any;
    getDataRect(): wjcCore.Rect;
    _clearValues(): void;
    _shouldCalculate(): boolean;
    _init(): void;
    _calculate(): void;
    private _rendering(sender, args);
    getCalculatedValues(key: string): any[];
}
export declare function _stochastic(highs: number[], lows: number[], closes: number[], kPeriod: number, dPeriod: number, smoothingPeriod: number): any;
