import * as wjcChart from 'wijmo/wijmo.chart';
import * as wjcCore from 'wijmo/wijmo';
/**
 * Specifies the type of radar chart.
 */
export declare enum RadarChartType {
    /** Shows vertical bars and allows you to compare values of items across categories. */
    Column = 0,
    /** Shows patterns within the data using X and Y coordinates. */
    Scatter = 1,
    /** Shows trends over a period of time or across categories. */
    Line = 2,
    /** Shows line chart with a symbol on each data point. */
    LineSymbols = 3,
    /** Shows line chart with the area below the line filled with color. */
    Area = 4,
}
/**
 * radar chart control.
 */
export declare class FlexRadar extends wjcChart.FlexChartCore {
    private _chartType;
    private _startAngle;
    private _totalAngle;
    private _reversed;
    _center: wjcCore.Point;
    _radius: number;
    _angles: number[];
    _isPolar: boolean;
    _areas: any[];
    private __radarLinePlotter;
    private __radarColumnPlotter;
    /**
     * Initializes a new instance of the @see:FlexRadar class.
     *
     * @param element The DOM element that hosts the control, or a selector for the
     * host element (e.g. '#theCtrl').
     * @param options A JavaScript object containing initialization data for the
     * control.
     */
    constructor(element: any, options?: any);
    private _radarLinePlotter;
    private _radarColumnPlotter;
    _initAxes(): void;
    _layout(rect: wjcCore.Rect, size: wjcCore.Size, engine: wjcChart.IRenderEngine): void;
    /**
     * Gets or sets the type of radar chart to create.
     */
    chartType: RadarChartType;
    /**
     * Gets or sets the starting angle for the radar, in degrees.
     *
     * Angles are measured clockwise, starting at the 12 o'clock position.
     */
    startAngle: number;
    /**
     * Gets or sets the total angle for the radar, in degrees.  Its default value is 360.
     * The value must be greater than 0, or less than or equal to 360.
     */
    totalAngle: number;
    /**
     * Gets or sets a value that determines whether angles are reversed
     * (counter-clockwise).
     *
     * The default value is false, which causes angles to be measured in
     * the clockwise direction.
     */
    reversed: boolean;
    /**
     * Gets or sets a value that determines whether and how the series objects are stacked.
     */
    stacking: wjcChart.Stacking;
    _getChartType(): wjcChart.ChartType;
    _getPlotter(series: FlexRadarSeries): wjcChart._IPlotter;
    _convertPoint(radius: any, angle: any): wjcCore.Point;
    _createSeries(): wjcChart.SeriesBase;
    _clearCachedValues(): void;
    _performBind(): void;
    _render(engine: wjcChart.IRenderEngine, applyElement?: boolean): void;
}
/**
 * Represents a series of data points to display in the chart.
 *
 * The @see:FlexRadarSeries class supports all basic chart types. You may define
 * a different chart type on each @see:FlexRadarSeries object that you add to the
 * @see:FlexRadar series collection. This overrides the @see:chartType
 * property set on the chart that is the default for all @see:FlexRadarSeries objects
 * in its collection.
 */
export declare class FlexRadarSeries extends wjcChart.SeriesBase {
    private _finChartType;
    /**
     * Gets or sets the chart type for a specific series, overriding the chart type
     * set on the overall chart. Please note that ColumnVolume, EquiVolume,
     * CandleVolume and ArmsCandleVolume chart types are not supported and should be
     * set on the @see:FinancialChart.
     */
    chartType: RadarChartType;
    _getChartType(): wjcChart.ChartType;
    _getLabelPoint(dataPoint: wjcChart._DataPoint): wjcCore.Point;
}
/**
 * Represents an axis in the radar chart.
 */
export declare class FlexRadarAxis extends wjcChart.Axis {
    private _points;
    private _axisLabels;
    _height: number;
    _render(engine: wjcChart.IRenderEngine): void;
    _getHeight(engine: wjcChart.IRenderEngine, maxw: number): number;
    _updateActualLimits(dataType: wjcCore.DataType, dataMin: number, dataMax: number, labels?: string[], values?: number[]): void;
    _updateActualLimitsByChartType(labels: any, min: any, max: any): {
        min: any;
        max: any;
    };
    /**
     * Converts the specified value from data to pixel coordinates.
     *
     * @param val The data value to convert.
     * @param maxValue The max value of the data, it's optional.
     * @param minValue The min value of the data, it's optional.
     */
    convert(val: number, maxValue?: number, minValue?: number): number;
    _renderLineAndTitle(engine: any): void;
    _renderPolygon(engine: any, r: any, cls: any): void;
    _renderMinors(engine: wjcChart.IRenderEngine, ticks: number[], isVert: boolean, isNear: boolean): void;
    private _drawMinorTickLength(engine, tover, angle, pt);
    _renderLabelsAndTicks(engine: any, index: any, val: any, sval: any, labelAngle: any, tickMarks: any, showLabel: any, t1: any, t2: any): boolean;
    private _renderXGridLine(engine, chart, x, cls);
    private _renderYGridLine(engine, chart, y, cls);
    private _getXLabelVAlign(angle);
    private _getXLabelAlign(angle);
    _createTimeLabels(start: number, len: number, vals: number[], lbls: string[]): void;
}
/**
 * Line/scatter radar chart plotter.
 */
export declare class _RadarLinePlotter extends wjcChart._LinePlotter {
    isArea: boolean;
    plotSeries(engine: wjcChart.IRenderEngine, ax: wjcChart._IAxis, ay: wjcChart._IAxis, series: wjcChart._ISeries, palette: wjcChart._IPalette, iser: number, nser: number): void;
}
/**
 * Column(Rose) radar chart plotter.
 */
export declare class _RadarBarPlotter extends wjcChart._BarPlotter {
    adjustLimits(dataInfo: wjcChart._DataInfo, plotRect: wjcCore.Rect): wjcCore.Rect;
    plotSeries(engine: wjcChart.IRenderEngine, ax: wjcChart._IAxis, ay: wjcChart._IAxis, series: wjcChart._ISeries, palette: wjcChart._IPalette, iser: number, nser: number): void;
}
