/**
 * Created by Jc on 1-17-2017.
 */
'use strict';

/**
 * @ngdoc object
 * @name flickr
 *
 * @description
 * Main app module.
 *
 * @requires ui.router
 * @requires ngSanitize
 * @requires ngAnimate
 * @requires pascalprecht.translate
 * @requires tmh.dynamicLocale
 * @requires ui.bootstrap
 * @requires templates-app
 */
AppController.$inject = ['$state', '$log', '$scope'];
angular.module('flickr', [
    // imports
    'ui.router',
    'ngSanitize',
    'ngAnimate',
    'pascalprecht.translate',
    'tmh.dynamicLocale',
    'ui.bootstrap',
    'wj',
    //'oit-wijmo',
    // view templates
    'templates-app',
    // components
    'flickr.components.height',
    'flickr.components.columns',
    'flickr.components.base',
    'flickr.components.home'
    // add more component's here
])
    .controller('AppController', AppController);

/**
 * @ngdoc object
 * @name flickr:AppController
 *
 * @description
 * Main app controller.
 *
 * @requires $state
 * @requires $log
 * @requires $scope
 *
 * @ngInject
 */
function AppController($state, $log, $scope) {

    /* jshint validthis: true */
    var vm = this;
    activate();

    //-------------------------------------------------------------------------
    //
    //  Methods
    //
    //-------------------------------------------------------------------------
    /**
     * @ngdoc function
     * @name flickr.AppController:onStateChangeStartHandler
     *
     * @description
     * Fired whenever a state change starts. Will handle a redirect if necessary.
     *
     * @param {event} event fired on change start.
     * @param {object} toState data.
     * @param {object} toParams data.
     * @param {object} fromState data.
     * @param {object} fromParams data.
     *
     * @methodOf flickr:AppController
     */
    function onStateChangeStartHandler(event, toState, toParams, fromState, fromParams) {
        // do we have a redirect? do it!
        if (toState.redirectTo) {
            event.preventDefault();
            $state.go(toState.redirectTo, toParams);
        }
    }

    /**
     * @ngdoc function
     * @name flickr.AppController:onStateChangeStartHandler
     *
     * @description
     * Fired whenever a state change is successful. Will log as necessary.
     *
     * @param {event} event fired on change start.
     * @param {object} toState data.
     * @param {object} toParams data.
     * @param {object} fromState data.
     * @param {object} fromParams data.
     *
     * @methodOf flickr:AppController
     */
    function onStateChangeEndHandler(event, toState, toParams, fromState, fromParams) {
        $log.log(toState.name, 'loaded');
    }

    /**
     * @ngdoc function
     * @name flickr.AppController:onStateChangeErrorHandler
     *
     * @description
     * Fired whenever a state change is errored. Will log to console as necessary.
     *
     * @methodOf flickr:AppController
     */
    function onStateChangeErrorHandler(event, toState, toParams, fromState, fromParams, error) {
        $log.error(toState.name, error.statusText);
    }

    /**
     * @ngdoc function
     * @name flickr.AppController:activate
     *
     * @description
     * Sets up view listeners.
     *
     * @methodOf flickr:AppController
     */
    function activate() {
        $scope.$on('$stateChangeStart', onStateChangeStartHandler);
        $scope.$on('$stateChangeSuccess', onStateChangeEndHandler);
        $scope.$on('$stateChangeError', onStateChangeErrorHandler);
    }
}

