/**
 * Created by Jc on 1-17-2017.
 */
'use strict';

flickrRunConfig.$inject = ['$translateProvider', '$urlRouterProvider', '$httpProvider'];
flickrRun.$inject = ['$rootScope', '$state', '$stateParams'];
angular.module('flickr')
    .config(flickrRunConfig)
    .run(flickrRun);

/**
 * @ngdoc function
 * @name flickr:flickrRunConfig
 *
 * @description
 * sets up translations and default routing.
 *
 * @methodOf flickr
 *
 * @requires $translateProvider
 * @requires $urlRouterProvider
 * @requires $httpProvider
 *
 * @ngInject
 */
function flickrRunConfig($translateProvider, $urlRouterProvider, $httpProvider) {
    $urlRouterProvider.otherwise('/home');
}

/**
 * @ngdoc function
 * @name flickr:flickrRun
 *
 * @description
 * Startup method. Starts loading the modules.
 *
 * @methodOf flickr
 *
 * @requires $rootScope
 * @requires $state
 * @requires $stateParams
 *
 * @ngInject
 */
function flickrRun($rootScope, $state, $stateParams) {
    $rootScope.$state = $state;
    $rootScope.$stateParams = $stateParams;

    $rootScope.$on('$stateChangeStart', onStateChangeStartHandler);

    /**
     * @ngdoc function
     * @name flickr.flickrRun:onStateChangeStartHandler
     *
     * @description
     * Fired whenever a state change starts. Will handle a redirect if necessary.
     *
     * @methodOf flickr:flickrRun
     */
    function onStateChangeStartHandler(event, toState, toParams, fromState, fromParams) {
        // do we have a redirect? do it!
        if (toState.redirectTo) {
            event.preventDefault();
            $state.go(toState.redirectTo, toParams);
        }
    }
}
