/**
 * Created by Jc on 1-17-2017.
 */
'use strict';

/**
 * @ngdoc object
 * @name flickr.components.base
 *
 * @description
 * View/Controller module.
 *
 * @requires ui.router
 */
BaseController.$inject = ['$state', '$stateParams'];
angular
    .module('flickr.components.base', [
        'ui.router'
    ])
    .controller('BaseController', BaseController);

/**
 * @ngdoc object
 * @name flickr.components.base:BaseController
 *
 * @description
 * View Mediator.
 *
 * @requires $state
 * @requires $stateParams
 *
 * @ngInject
 */
function BaseController($state, $stateParams) {

    /* jshint validthis: true */
    var vm = this; // <- this is your $scope
    // add your ctrl variables here at the top
    vm.title = 'Base View';
    vm.initGrid = initGrid;
    // map your view accessible functions to the vm here
    activate();

    //-------------------------------------------------------------------------
    //
    //  Methods
    //
    //-------------------------------------------------------------------------
    /**
     * @ngdoc function
     * @name flickr.components.base.BaseController:activate
     *
     * @description
     * - Called at Ctrl startup.
     * - Great place to add listeners/handlers.
     *
     * @methodOf flickr.components.base:BaseController
     */
    function activate() {
        var data = [];
        for (var i = 0, n = 1000; i < n; i++) {
            var item = {
                'row': i.toString(),
                'status': 'status' + i,
                'entityNumber': 'entityNumber' + i,
                'entityName': 'entityName' + i,
                'binderName': 'binderName' + i,
                'formName': 'formName' + i,
                'requestDateTime': 'requestDateTime' + i,
                'acknowledgeDateTime': 'acknowledgeDateTime' + i,
                'acceptRejectDateTime': 'acceptRejectDateTime' + i
            };
            if (i % 2 === 0) {
                item.statusClass = 'bento-icon-save-solid green';
                item.entityImage = 'icon_binder.svg';
                item.entityNumberClass = 'divcon';
            } else {
                item.statusClass = 'bento-icon-warning-round red';
                item.entityImage = 'icon_entity_division.svg';
                item.entityNumberClass = 'eliminations';
            }
            data.push(item);
        }
        vm.data = data;
    }

    /**
     * @ngdoc function
     * @name flickr.components.base.BaseController:initGrid
     *
     * @description
     * Initilizes the grid set up
     *
     * @methodOf flickr.components.base:BaseController
     *
     */
    function initGrid(s, e) {
        vm.flexgrid = s;
        vm.flexgrid.frozenColumns = 5;
        //Add a event handler for Sort as well
        var cv = vm.flexgrid.collectionView;

        if (!cv) {
            return;
        }
        vm.gridFilter = new wijmo.grid.filter.FlexGridFilter(s);
    }

}
