/**
 * Created by Jc on 1-17-2017.
 */
'use strict';
/**
 * @ngdoc object
 * @name flickr.components.base
 *
 * @description
 * View module.
 */
baseConfig.$inject = ['$stateProvider'];
angular
    .module('flickr.components.base')
    .config(baseConfig);

/**
 * @ngdoc function
 * @name flickr.components.base:configure
 *
 * @description
 * Adds routing between ctrl and view template.
 *
 * @methodOf flickr.components.base
 *
 * @requires $stateProvider
 *
 * @ngInject
 */
function baseConfig($stateProvider) {
    resolves.$inject = ['$q'];
    $stateProvider
        .state('base', {
            url: '/base',
            templateUrl: 'components/base/base.tpl.html',
            controller: 'BaseController',
            controllerAs: 'baseCtrl',
            resolve: {
                onLoad: resolves
            }
        });

    /**
     * @ngdoc function
     * @name flickr.components.base.configure:resolves
     *
     * @description
     * loads models necessary for view when activated.
     *
     * @methodOf flickr.components.base:configure
     *
     * @requires $q
     *
     * @ngInject
     */
    function resolves($q) {
        var resolves = [
            // list multiple models to load here
        ];
        return $q.all(resolves);
    }
}
