/**
 * Created by Jc on 1-17-2017.
 */
'use strict';

/**
 * @ngdoc object
 * @name flickr.components.home
 *
 * @description
 * View/Controller module.
 *
 * @requires ui.router
 */
HomeController.$inject = ['$state', '$stateParams'];
angular
    .module('flickr.components.home', [
        'ui.router'
    ])
    .controller('HomeController', HomeController);

/**
 * @ngdoc object
 * @name flickr.components.home:HomeController
 *
 * @description
 * View Mediator.
 *
 * @requires $state
 * @requires $stateParams
 *
 * @ngInject
 */
function HomeController($state, $stateParams) {

    /* jshint validthis: true */
    var vm = this; // <- this is your $scope
    // add your ctrl variables here at the top
    vm.title = 'Custom Height and Columns';
    vm.initGrid = initGrid;
    vm.onClick = onClick;
    // map your view accessible functions to the vm here
    activate();

    //-------------------------------------------------------------------------
    //
    //  Methods
    //
    //-------------------------------------------------------------------------
    /**
     * @ngdoc function
     * @name flickr.components.home.HomeController:activate
     *
     * @description
     * - Called at Ctrl startup.
     * - Great place to add listeners/handlers.
     *
     * @methodOf flickr.components.home:HomeController
     */
    function activate() {
        var data = [];
        for (var i = 0, n = 1000; i < n; i++) {
            var item = {
                'row': i.toString(),
                'status': 'status' + i,
                'entityNumber': 'entityNumber' + i,
                'entityName': 'entityName' + i,
                'binderName': 'binderName' + i,
                'formName': 'formName' + i,
                'requestDateTime': 'requestDateTime' + i,
                'acknowledgeDateTime': 'acknowledgeDateTime' + i,
                'acceptRejectDateTime': 'acceptRejectDateTime' + i
            };
            if (i % 2 === 0) {
                item.statusClass = 'bento-icon-save-solid green';
                item.entityImage = 'icon_binder.svg';
                item.entityNumberClass = 'divcon';
            } else {
                item.statusClass = 'bento-icon-warning-round red';
                item.entityImage = 'icon_entity_division.svg';
                item.entityNumberClass = 'eliminations';
            }
            data.push(item);
        }
        vm.data = data;
    }

    /**
     * @ngdoc function
     * @name flickr.components.home.HomeController:initGrid
     *
     * @description
     * Initilizes the grid set up
     *
     * @methodOf flickr.components.home:HomeController
     *
     */
    function initGrid(s, e) {
        vm.flexgrid = s;
        vm.flexgrid.rows.defaultSize = 30;
        vm.flexgrid.columnHeaders.rows.defaultSize = 36;
        vm.flexgrid.frozenColumns = 5;
        //Add a event handler for Sort as well
        var cv = vm.flexgrid.collectionView;

        if (!cv) {
            return;
        }
        vm.gridFilter = new wijmo.grid.filter.FlexGridFilter(s);
    }

    /**
     * @ngdoc function
     * @name flickr.components.home.HomeController:onClick
     *
     * @description
     * Initilizes the grid set up
     *
     * @methodOf flickr.components.home:HomeController
     *
     */
    function onClick(item) {
        alert(item.status);
    }

}
