/**
 * Created by Jc on 1-17-2017.
 */
'use strict';

angular.module('oit.app.filters.findby', [])
    .filter('findby', findbyFilter);

/**
 * @ngdoc filter
 * @name oit.app.filters.findby
 *
 * @description
 * finds an object in a list based on a property.
 *
 * @returns {string} filtered string.
 * @example
 * <doc:example module="filters.demo">
 *     <doc:source>
 *         <script>
 *             function Ctrl($scope) {
 *              $scope.list = [
 *                  {"a":1, "b":2, "c":3},
 *                  {"a":4, "b":5, "c":6},
 *                  {"a":7, "b":8, "c":9}
 *              ];
 *              $scope.match = 2;
 *              $scope.property = "b";
 *             }
 *         </script>
 *         <div ng-controller="Ctrl">
 *             <table>
 *                 <tr>
 *                     <td>Match:</td>
 *                     <td><input ng-model="match"></td>
 *                 </tr>
 *                 <tr>
 *                     <td>Property:</td>
 *                     <td><input ng-model="property"></td>
 *                 </tr>
 *             </table>
 *             <hr/>
 *             <p>Original List:<br/>
 *             {{list}}
 *             </p>
 *             <hr/>
 *             <p>Found Item:<br/>
 *             {{list | findby:match:property }}
 *             </p>
 *         </div>
 *     </doc:source>
 * </doc:example>
 *
 * @ngInject
 */
function findbyFilter() {

    /**
     * @ngdoc function
     * @name oit.app.filters.findby#find
     *
     * @description
     * finds by id or property.
     *
     * @param {array} input list to search through.
     * @param {object} match value to compare (using string compare).
     * @param {string} property to search by.
     *
     * @methodOf oit.app.filters.findby
     *
     * @returns {object|null} found object.
     */
    function findby(input, match, property) {
        // undefined check
        property = property || 'id';
        // null check
        if (!input || input.length === 0 || !match) {
            return null;
        }
        // find it!
        for (var i = 0, n = input.length; i < n; i++) {
            // null check
            if (!input[i][property]) {
                continue;
            }
            // check
            if (input[i][property].toString() === match.toString()) {
                return input[i];
            }
        }
        // not found
        return null;
    }

    return findby;
}
