module.exports = function (karma) {
    karma.set({
        /**
         * From where to look for files, starting with the location of this file.
         */
        basePath: '../',

        /**
         * This is the list of file patterns to load into the browser during testing.
         */
        files: [
        'bower_components/jquery/dist/jquery.js',
            'bower_components/angular/angular.js',
            'bower_components/angular-translate/angular-translate.js',
            'bower_components/angular-ui-router/release/angular-ui-router.js',
            'bower_components/angular-animate/angular-animate.js',
            'bower_components/angular-dynamic-locale/src/tmhDynamicLocale.js',
            'bower_components/angular-sanitize/angular-sanitize.js',
            'bower_components/angular-bootstrap/ui-bootstrap-tpls.js',
            'bower_components/underscore/underscore.js',
            'lib/wijmo/5_20161_164/wijmo.js',
            'lib/wijmo/5_20161_164/wijmo.grid.js',
            'lib/wijmo/5_20161_164/wijmo.input.js',
            'lib/wijmo/5_20161_164/wijmo.grid.filter.js',
            'lib/wijmo/jszip.js',
            'lib/wijmo/5_20161_164/wijmo.grid.detail.js',
            'lib/wijmo/5_20161_164/wijmo.xlsx.js',
            'lib/wijmo/5_20161_164/wijmo.grid.xlsx.js',
            'lib/wijmo/5_20161_164/wijmo.angular.js',
            'lib/wijmo/ExcelConverter.js',
            'lib/wijmo/c1xlsx.js',
            'lib/wijmo/column_group_provider.js',
            'bower_components/angular-local-storage/dist/angular-local-storage.js',
            'bower_components/bootstrap/dist/js/bootstrap.js',
            'bower_components/angular-translate-loader-static-files/angular-translate-loader-static-files.js',
            'build/templates-app.js',
            'bower_components/angular-mocks/angular-mocks.js',
            
    'client/**/*.js'
    ],
    exclude: [
        'client/assets/**/*.js',
        'client/**/*.e2e.js'
    ],
        frameworks: [ 'jasmine' ],
        plugins: [ 'karma-jasmine', 'karma-coverage', 'karma-firefox-launcher', 'karma-chrome-launcher', 'karma-phantomjs-launcher' ],
        preprocessors: {
            'client/**/!(*spec).js': ['coverage']
    },

    /**
     * How to report, by default.
     */
    reporters: ['dots', 'coverage'],

        coverageReporter: {
        reporters:[
            {type: 'html', subdir: '/html'},
            {type: 'cobertura', subdir: '/jenkins'}
        ],
            dir: './reports/coverage/'
    },

    /**
     * On which port should the browser connect, on which port is the test runner
     * operating, and what is the URL path for the browser to use.
     */
    port: 9018,
        runnerPort: 9100,
        urlRoot: '/',

        /**
         * Disable file watching by default.
         */
        autoWatch: false,

        /**
         * The list of browsers to launch to test on. This includes only "Firefox" by
         * default, but other browser names include:
         * Chrome, ChromeCanary, Firefox, Opera, Safari, PhantomJS
         *
         * Note that you can also use the executable name of the browser, like "chromium"
         * or "firefox", but that these vary based on your operating system.
         *
         * You may also leave this blank and manually navigate your browser to
         * http://localhost:9018/ when you're running tests. The window/tab can be left
         * open and the tests will automatically occur there during the build. This has
         * the aesthetic advantage of not launching a browser every time you save.
         */
        browsers: [
        'Chrome'
    ]
});
};

