/*
    *
    * Wijmo Library 5.20161.138
    * http://wijmo.com/
    *
    * Copyright(c) GrapeCity, Inc.  All rights reserved.
    *
    * Licensed under the Wijmo Commercial License.
    * sales@wijmo.com
    * http://wijmo.com/products/wijmo-5/license/
    *
    */
import { ElementRef, Injector, ViewContainerRef, TemplateRef, Renderer, AppViewManager } from 'angular2/core';
import * as ngCore from 'angular2/core';
/**
 * Angular 2 component for the @see:ComboBox control.
 *
 * Use the <b>wj-combo-box</b> component to add <b>ComboBox</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjComboBox</b> component is derived from the <b>ComboBox</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjComboBox extends wijmo.input.ComboBox {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:AutoComplete control.
 *
 * Use the <b>wj-auto-complete</b> component to add <b>AutoComplete</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjAutoComplete</b> component is derived from the <b>AutoComplete</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjAutoComplete extends wijmo.input.AutoComplete {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:Calendar control.
 *
 * Use the <b>wj-calendar</b> component to add <b>Calendar</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjCalendar</b> component is derived from the <b>Calendar</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjCalendar extends wijmo.input.Calendar {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:ColorPicker control.
 *
 * Use the <b>wj-color-picker</b> component to add <b>ColorPicker</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjColorPicker</b> component is derived from the <b>ColorPicker</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjColorPicker extends wijmo.input.ColorPicker {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:InputMask control.
 *
 * Use the <b>wj-input-mask</b> component to add <b>InputMask</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjInputMask</b> component is derived from the <b>InputMask</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjInputMask extends wijmo.input.InputMask {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:InputColor control.
 *
 * Use the <b>wj-input-color</b> component to add <b>InputColor</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjInputColor</b> component is derived from the <b>InputColor</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjInputColor extends wijmo.input.InputColor {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:MultiSelect control.
 *
 * Use the <b>wj-multi-select</b> component to add <b>MultiSelect</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjMultiSelect</b> component is derived from the <b>MultiSelect</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjMultiSelect extends wijmo.input.MultiSelect {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:InputNumber control.
 *
 * Use the <b>wj-input-number</b> component to add <b>InputNumber</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjInputNumber</b> component is derived from the <b>InputNumber</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjInputNumber extends wijmo.input.InputNumber {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:InputDate control.
 *
 * Use the <b>wj-input-date</b> component to add <b>InputDate</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjInputDate</b> component is derived from the <b>InputDate</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjInputDate extends wijmo.input.InputDate {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:InputTime control.
 *
 * Use the <b>wj-input-time</b> component to add <b>InputTime</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjInputTime</b> component is derived from the <b>InputTime</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjInputTime extends wijmo.input.InputTime {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:InputDateTime control.
 *
 * Use the <b>wj-input-date-time</b> component to add <b>InputDateTime</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjInputDateTime</b> component is derived from the <b>InputDateTime</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjInputDateTime extends wijmo.input.InputDateTime {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:ListBox control.
 *
 * Use the <b>wj-list-box</b> component to add <b>ListBox</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjListBox</b> component is derived from the <b>ListBox</b> control and
 * inherits all its properties, events and methods.
 *
 * The <b>wj-list-box</b> component may contain @see:wijmo/wijmo.angular2.input.WjItemTemplate
 * child directive.
*/
export declare class WjListBox extends wijmo.input.ListBox {
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for the @see:Menu control.
 *
 * Use the <b>wj-menu</b> component to add <b>Menu</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The <b>WjMenu</b> component is derived from the <b>Menu</b> control and
 * inherits all its properties, events and methods.
 *
 * The <b>wj-menu</b> component may contain the following child components and directives:
 * @see:wijmo/wijmo.angular2.input.WjMenuItem,
 * @see:wijmo/wijmo.angular2.input.WjMenuSeparator and
 * @see:wijmo/wijmo.angular2.input.WjItemTemplate (in case of data-bound Menu control).
*/
export declare class WjMenu extends wijmo.input.Menu implements ngCore.OnInit, ngCore.OnDestroy, ngCore.OnChanges, ngCore.AfterContentInit {
    private _value;
    private _definedHeader;
    private _appRef;
    private _cdRef;
    constructor(elRef: ElementRef, injector: Injector, appRef: ngCore.ApplicationRef, cdRef: ngCore.ChangeDetectorRef);
    value: any;
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: {
        [key: string]: ngCore.SimpleChange;
    }): void;
    ngAfterContentInit(): void;
    refresh(fullUpdate?: boolean): void;
    private _attachToControl();
    private _loadingItems(s);
    private _fmtItem(s, e);
    private _updateHeader();
}
/**
 * Angular 2 directive for menu items.
 *
 * The <b>wj-menu-item</b> component must be contained in a @see:wijmo/wijmo.angular2.input.WjMenu directive.
 * It supports the following attributes:
 *
 * <dl class="dl-horizontal">
 *   <dt>[cmd]</dt>       <dd>The function to execute in the controller
 *                      when the item is clicked.</dd>
 *   <dt>[cmdParam]</dt>  <dd>The parameter passed to the <b>cmd</b> function
 *                      when the item is clicked.</dd>
 *   <dt>[(value)]</dt>     <dd>The value to select when the item is clicked
 *                      (use either this or <b>cmd</b>).</dd>
 * </dl>
 *
 * The content displayed by the item may contain an arbitrary HTML fragment with Angular 2 bindings,
 * components and directives.
 * You can also use <b>ngFor</b> and <b>ngIf</b> directives to populate the items in the Menu control.
 * The local <b>item</b>,
 * <b>itemIndex</b> and <b>control</b> template variables can be used in Angular 2 bindings
 * that refer to the data item, its index, and the owner control.
 */
export declare class WjMenuItem implements ngCore.OnInit, ngCore.AfterContentInit {
    elRef: ElementRef;
    private viewContainerRef;
    private appViewManager;
    private domRenderer;
    value: string;
    cmd: string;
    cmdParam: string;
    header: string;
    _ownerMenu: wijmo.input.Menu;
    templateDir: WjMenuItemTemplateDir;
    contentRoot: HTMLElement;
    constructor(elRef: ElementRef, injector: Injector, viewContainerRef: ViewContainerRef, appViewManager: AppViewManager, domRenderer: Renderer);
    ngOnInit(): void;
    wjAfterParentInit(): void;
    ngAfterContentInit(): void;
}
/**
 * Angular 2 component for menu separators.
 *
 * The <b>wj-menu-item-separator</b> component must be contained in a
 * @see:wijmo/wijmo.angular2.input.WjMenu directive.
 * It adds a non-selectable separator to the menu, and has no attributes.
 */
export declare class WjMenuSeparator extends WjMenuItem implements ngCore.OnInit {
    constructor(elRef: ElementRef, injector: Injector, viewContainerRef: ViewContainerRef, appViewManager: AppViewManager, domRenderer: Renderer);
    ngOnInit(): void;
}
export declare class WjMenuItemTemplateDir implements ngCore.OnInit, ngCore.AfterContentInit {
    viewContainerRef: ViewContainerRef;
    templateRef: TemplateRef;
    elRef: ElementRef;
    private domRenderer;
    wjMenuItemTemplateDir: any;
    ownerItem: WjMenuItem;
    contentRoot: HTMLElement;
    constructor(viewContainerRef: ViewContainerRef, templateRef: TemplateRef, elRef: ElementRef, injector: Injector, domRenderer: Renderer, menuItem: WjMenuItem, menuSeparator: WjMenuSeparator);
    ngOnInit(): void;
    ngAfterContentInit(): void;
}
/**
 * TBD
 */
export declare class WjItemTemplate implements ngCore.OnInit, ngCore.OnDestroy {
    viewContainerRef: ViewContainerRef;
    templateRef: TemplateRef;
    elRef: ElementRef;
    private domRenderer;
    wjItemTemplate: any;
    ownerControl: wijmo.Control;
    listBox: wijmo.input.ListBox;
    constructor(viewContainerRef: ViewContainerRef, templateRef: TemplateRef, elRef: ElementRef, injector: Injector, domRenderer: Renderer);
    ngOnInit(): void;
    ngOnDestroy(): void;
    private _attachToControl();
    private _loadingItems(s);
    private _fmtItem(s, e);
    private _instantiateTemplate(parent);
    private static _getListBox(ownerControl);
}
/**
 * Angular 2 component for the @see:Popup control.
 *
 * Use the <b>wj-popup</b> component to add <b>Popup</b> controls to your
 * Angular 2 applications. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>.
 *
 * The popup content may be specified inside the <b>wj-popup</b> tag, and can
 * contain an arbitrary HTML fragment with Angular 2 bindings, components
 * and directives.
 *
 * The <b>WjPopup</b> component is derived from the <b>Popup</b> control and
 * inherits all its properties, events and methods.
*/
export declare class WjPopup extends wijmo.input.Popup implements ngCore.OnChanges {
    private _elRef;
    constructor(elRef: ElementRef, injector: Injector);
    ngOnChanges(changes: {
        [key: string]: ngCore.SimpleChange;
    }): void;
    dispose(): void;
}
/**
 * Angular 2 directive for context menus.
 *
 * Use the <b>wjContextMenu</b> directive to add context menus to elements
 * on the page. The wjContextMenu directive is based on the <b>wj-menu</b>
 * component; it displays a popup menu when the user performs a context menu
 * request on an element (usually a right-click).
 *
 * The wjContextMenu directive is specified as a parameter added to the
 * element that the context menu applies to. The parameter value is a
 * reference to the <b>wj-menu</b> component. For example:
 *
 * <pre>&lt;!-- paragraph with a context menu --&gt;
 *&lt;p [wjContextMenu]="menu" &gt;
 *  This paragraph has a context menu.&lt;/p&gt;
 *
 *&lt;!-- define the context menu (hidden and with an id) --&gt;
 *&lt;wj-menu #menu style="display:none"&gt;
 *  &lt;wj-menu-item [cmd]="cmdOpen" [cmdParam] ="1"&gt;Open...&lt;/wj-menu-item&gt;
 *  &lt;wj-menu-item [cmd]="cmdSave" [cmdParam]="2"&gt;Save &lt;/wj-menu-item&gt;
 *  &lt;wj-menu-item [cmd]="cmdSave" [cmdParam]="3"&gt;Save As...&lt;/wj-menu-item&gt;
 *  &lt;wj-menu-item [cmd]="cmdNew" [cmdParam] ="4"&gt;New...&lt;/wj-menu-item&gt;
 *  &lt;wj-menu-separator&gt;&lt;/wj-menu-separator&gt;
 *  &lt;wj-menu-item [cmd]="cmdExit" [cmdParam]="5"&gt;Exit&lt;/wj-menu-item&gt;
 *&lt;/wj-menu &gt;</pre>
 */
export declare class WjContextMenu {
    private elRef;
    wjContextMenu: wijmo.input.Menu;
    constructor(elRef: ElementRef);
    onContextMenu(e: MouseEvent): void;
}
/**
 * Angular 2 component for an @see:ICollectionView navigator element.
 *
 * Use the <b>wj-collection-view-navigator</b> component to add an element that allows users to
 * navigate through the items in an @see:ICollectionView. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>. For example:
 *
 * &lt;wj-collection-view-navigator
 *   [cv]="myCollectionView"&gt;
 * &lt;/wj-collection-view-navigator&gt;</pre>
 */
export declare class WjCollectionViewNavigator {
    cv: wijmo.collections.CollectionView;
    constructor(elRef: ElementRef, injector: Injector);
}
/**
 * Angular 2 component for an @see:ICollectionView pager element.
 *
 * Use the <b>wj-collection-view-pager</b> component to add an element that allows users to
 * navigate through the pages in a paged @see:ICollectionView. For details about Angular 2 markup syntax, see
 * <a href="static/angular2Markup.html">Angular 2 Markup</a>. For example:
 *
 * &lt;wj-collection-view-pager
 *   [cv]="myCollectionView"&gt;
 * &lt;/wj-collection-view-pager&gt;</pre>
 */
export declare class WjCollectionViewPager {
    cv: wijmo.collections.CollectionView;
    constructor(elRef: ElementRef, injector: Injector);
}
