﻿///<reference path="../node_modules/angular2/typings/browser.d.ts"/>

// Angular
import { Component, View, EventEmitter, provide, Input, Inject, enableProdMode } from 'angular2/core';
import { CORE_DIRECTIVES } from 'angular2/common';
import { bootstrap } from 'angular2/platform/browser';
import  * as wjNg2Input from 'wijmo/wijmo.angular2.input';
import { ToDatePipe } from './pipes/appPipes';
import { AppTab, AppTabPane } from './components/AppTab';
import { DataSvc } from './services/DataSvc';

    'use strict';

    // The Explorer application root component.
    @Component({
        selector: 'app-cmp',
        templateUrl: 'src/app.html',
        directives: [CORE_DIRECTIVES, AppTab, AppTabPane, wjNg2Input.WjAutoComplete],
        pipes: [ToDatePipe]
    })
    export class AppCmp {
        protected dataSvc: DataSvc;
        public data: wijmo.collections.CollectionView;
        public data1: wijmo.collections.CollectionView;
        constructor( @Inject(DataSvc) dataSvc: DataSvc) {
            // values for InputDate, InputTime, InputDateTime
            this.dataSvc = dataSvc;
            this.data = new wijmo.collections.CollectionView(this.dataSvc.getMusicians());
            this.data1 = new wijmo.collections.CollectionView(this.dataSvc.getMusicians());
            this.data1.currentItem = null;
        }
       
}


enableProdMode();
// Bootstrap application with hash style navigation and global services.
bootstrap(AppCmp, [
    DataSvc
]);