import * as React from 'react';
import * as _ from 'lodash';
import {GridOptions, ColDef} from 'ag-grid';
import { GridViewModel } from '../../core/grid/GridViewModel';
import {RemoteDispatcher} from '../../core/connect';
import {MessageBusClient} from '../../core/ClientServices';
import {SOCKET_RECOVERY} from '../../core/connectionStatus/ConnectionStatusProvider';
import {Message} from '../../messaging/messagebus/Message';
import '!style!css!ag-grid-root/dist/styles/ag-grid.css';
import '!style!css!./Blotter.css';
import '!style!css!wijmo-root/styles/wijmo.css';
import '!style!css!wijmo-root/styles/themes/wijmo.theme.superhero.css';
import 'wijmo.react';
import CancelEventArgs = wijmo.CancelEventArgs;

export interface BlotterProps extends RemoteDispatcher {
  columnDefs: ColDef[];
  rowIdField?: string;
  filterTarget?: string;
  filterField?: string;
  getContextMenuItems?: any;
}

export class Blotter extends React.Component<BlotterProps, {}> {
  private gridOptions: GridOptions;
  private gridViewModel: GridViewModel;
  private columns: Array<any> = [];
  private grid: any;

  constructor(props: BlotterProps, context: any) {
    super(props, context);

    for (let columnDefinition of this.props.columnDefs) {
      columnDefinition.suppressMenu = true;
      this.columns.push({
        header: columnDefinition.headerName,
        binding: columnDefinition.field,
        width: ((columnDefinition.width) ? columnDefinition.width : '*')
      });
    }

    this.gridOptions = {
      enableRangeSelection: false,
      enableColResize: true,
      enableServerSideSorting: true,
      enableServerSideFilter: true,
      columnDefs: this.props.columnDefs,
      rowModelType: 'viewport',
      rowSelection: 'multiple',
      rowDeselection: true,
      suppressCellSelection: true
    };

    if (!_.isUndefined(this.props.rowIdField)) {
      this.gridOptions.getRowNodeId = (rowData: any) => {
        if (_.isUndefined(this.props.rowIdField)) {
          throw new Error('rowIdField became unset');
        } else {
          return rowData[this.props.rowIdField];
        }
      };
    }

    // if (!_.isUndefined(this.props.filterField) && !_.isUndefined(this.props.filterTarget)) {
    //   this.gridOptions.onSelectionChanged = this.onSelectionChanged.bind(this);
    // }
    //
    // if (!_.isUndefined(this.props.getContextMenuItems)) {
    //   this.gridOptions.getContextMenuItems = this.props.getContextMenuItems;
    // }

    MessageBusClient.subscribe(SOCKET_RECOVERY, (msg: Message) => {
      if (this.grid) {
        this.grid.invalidate();
      }
    });
  }

  public render() {
    return (
      <div>
        <Wj.FlexGrid
          className='wj-flexgrid'
          style={{height: '200px'}}
          autoGenerateColumns={false}
          headersVisibility='Column'
          columns={this.columns}
          initialized={this.onGridReady}
        />
    </div>
    );
  }

  private readonly onGridReady = (s: any, e: any): void => {
    this.grid = s;
    this.gridViewModel = new GridViewModel(this.props);

    let handler = _.throttle((sender: any, args: any) => {
      let range = sender.viewRange;
      if (range.isValid) {
        sender.itemsSource.setViewport(range.row, range.row2);
      }
    }, 50);

    this.grid.scrollPositionChanged.addHandler(handler, this.grid);

    this.grid.childItemsPath='children';
    this.grid.itemsSource = this.gridViewModel;

    // if (_.isUndefined(this.props.filterTarget)) {
    //   return;
    // }
    //
    // const setFilterRequest = new GridSetFilterRequest()
    //   .setTarget(this.props.filterTarget);
    // this.props.send(setFilterRequest);
  }

  // private readonly onSelectionChanged = (): void => {
  //   if (_.isUndefined(this.props.filterField) || _.isUndefined(this.props.filterTarget)) {
  //     throw new Error('filterField became unset');
  //   }
  //
  //   const selectedRows: any[] = [];// this.gridApi.getSelectedRows();
  //   const selectedIds: number[] = [];
  //
  //   if (selectedRows.length === 1) {
  //     const filterValue = selectedRows[0][this.props.filterField];
  //     if (_.isNil(filterValue)) {
  //       return;
  //     }
  //     console.log('Row has been selected. filtervalue = ' + filterValue);
  //     selectedIds.push(filterValue);
  //   } else if (selectedRows.length > 1) {
  //     for (let i = 0; i < selectedRows.length; i++) {
  //       const filterValue = selectedRows[i][this.props.filterField];
  //       if (_.isNil(filterValue)) {
  //         continue;
  //       }
  //       selectedIds.push(filterValue);
  //     }
  //   }
  //
  //   const setFilterRequest = new GridSetFilterRequest()
  //     .setTarget(this.props.filterTarget)
  //     .setField(this.props.filterField);
  //
  //   if (selectedIds.length > 0) {
  //     setFilterRequest.setValuesList(selectedIds);
  //   }
  //
  //   this.props.send(setFilterRequest);
  // }
}
