import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';
import * as wjFilter from 'wijmo/wijmo.grid.filter';
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    title = 'FlexGrid';
    public data: wjCore.CollectionView;
    protected dataSvc: DataSvc;

   
    constructor( @Inject(DataSvc) dataSvc: DataSvc) {
        this.dataSvc = dataSvc;
        this.data = new wjCore.CollectionView(this.dataSvc.getData(100000));
        console.log(this.data.items);
    }

    init(s: wjSheet.FlexSheet, e: wjCore.EventArgs) {
        for (let i = 0; i < s.columns.length; i++) {
            s.columns[i].width = "*";
        }       
    }
  
}
