import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';


@Component({
    selector: 'app-root',
    templateUrl: './app.component.html',
    styleUrls: ['./app.component.css']
})
export class AppComponent {
    title = 'FlexGrid';


    public data: wjCore.CollectionView;
    public country: wjCore.CollectionView;
    protected dataSvc: DataSvc;

    @ViewChild('flex') flex: wjSheet.FlexSheet;
    constructor( @Inject(DataSvc) dataSvc: DataSvc) {
        this.dataSvc = dataSvc;
        this.data = new wjCore.CollectionView(this.dataSvc.getData(20));
    }
    addRow() {
        this.data.sourceCollection.splice(this.flex.selection.row, 0, {});
    }
    initialized(s: wjSheet.FlexSheet, e: wjCore.EventArgs) {
        s.columns[1].dataMap = new wjGrid.DataMap(this.dataSvc.getCountry());
    }

}
