﻿///<reference path="../typings/globals/core-js/index.d.ts"/>
'use strict';

import { Component, EventEmitter, Inject, enableProdMode, ViewChild, NgModule, OnInit } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
import { BrowserModule } from '@angular/platform-browser';
import { WjGridModule } from 'wijmo/wijmo.angular2.grid';
import { WjInputModule } from 'wijmo/wijmo.angular2.input';


import * as wjcInput from 'wijmo/wijmo.input';
import * as wjcGrid from 'wijmo/wijmo.grid';
import * as wjcCore from 'wijmo/wijmo';


import { DataSvc } from './services/DataSvc';

@Component({
    selector: 'app-cmp',
    templateUrl: '../src/AppCmp.html'
})
export class AppCmp {
    public dataList:any[]=[] ;
    private _dataSvc: DataSvc;
    constructor( @Inject(DataSvc) _dataSvc: DataSvc) {
        this._dataSvc = _dataSvc;
        this.dataList.push({ header: 'Simple Array', value: this._dataSvc.getData(10) });
        this.dataList.push({ header: 'Observable Array', value: this._dataSvc.getObservableData(10) });
        this.dataList.push({ header: 'CollectionView with simple Array', value: new wjcCore.CollectionView(this._dataSvc.getData(10))});
        this.dataList.push({ header: 'CollectionView with Observable Array', value: new wjcCore.CollectionView(this._dataSvc.getObservableData(10)) });
    }
    init(s: wjcGrid.FlexGrid, e: wjcCore.EventArgs) {
        s.collectionView.currentItem = null; // if FlexGrid is bind to CollectionView, just make CollectionView currentItem property to null
    }

}
@NgModule({
    imports: [WjInputModule, WjGridModule, BrowserModule, FormsModule],
    declarations: [AppCmp],
    providers: [DataSvc],
    bootstrap: [AppCmp]
})
export class AppModule {
}


enableProdMode();
// Bootstrap application with hash style navigation and global services.
platformBrowserDynamic().bootstrapModule(AppModule);



