import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data = [{
        name: "car",
        price: 25445,
        qty: 1,
        items: [
            {
                name: "wheel",
                price: 342,
                qty: 4
            },
            {
                name: "engine",
                items: [
                    { col1: "Col1", col2: "Col2", col3: "Col3", col4: "Col4" },
                    { col1: "Col11", col2: "Col12", col3: "Col13", col4: "Col14" },
                ]
            },
            {
                name: "seat",
                price: 542,
                qty: 4
            },
            {
                name: "chassis",
                price: 4342,
                qty: 1
            }
        ]
    }];
    @ViewChild('flexSheet') flexSheet: wjSheet.FlexSheet; 
    ngAfterViewInit() {
        let grid = new wjGrid.FlexGrid(document.createElement('div'));
        grid.initialize({
            autoGenerateColumns:false,            
            itemsSource: this.data,
            columns: [
                { header: 'Name', binding: 'name' },
                { header: 'Price', binding: 'price' },
                { header: 'Quantity', binding: 'qty' },
                { header: 'Column1', binding: 'col1' }
            ]
           

        });
        this.flexSheet.sheets.push(new wjSheet.Sheet(this.flexSheet, grid, 'Sheet1'));
        console.log(this.flexSheet.sheets[0]); 
    }
}
