import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data = [{
        section: "Material", 
		fieldMateria1:"aloo",
		fieldMateria2:"anda",
		fieldMateria3:"gobi",		
        items: [           
            {
                section: "Fabric",               
                items: [
                
                    { fieldFabric1: "India", fieldFabric2: 67, fieldFabric3: "Medium"},
					{ fieldFabric1: "US", fieldFabric2: 45, fieldFabric3: "High"},
					{ fieldFabric1: "UK", fieldFabric2: 78, fieldFabric3: "Low"},  
					{ fieldFabric1: "Japan", fieldFabric2: 34, fieldFabric3: "Low"} 
                ]				
            },
			{
				section: "Trims",
                items: [
                    { fieldFabric1: "India", fieldFabric2: 23435, fieldFabric3: "High"}                   
                ]
			}
            
        ]
    }];
    @ViewChild('flexSheet') flexSheet: wjSheet.FlexSheet;
    groupCollapsedChanging(s: wjSheet.FlexSheet, e: wjGrid.CellRangeEventArgs) {
        let value = s.rows[e.row].dataItem.section,
            columns = s.columns;
        if (value !== "Material") {
            for (var i = 0; i < columns.length; i++) {
                if (columns[i].binding == "fieldMateria1") {
                    columns[i].visible = false;
                } if (columns[i].binding == "fieldMateria2") {
                    columns[i].visible = false;
                } if (columns[i].binding == "fieldMateria3") {
                    columns[i].visible = false;
                } if (columns[i].binding == "fieldFabric1") {
                    columns[i].visible = true;
                } if (columns[i].binding == "fieldFabric2") {
                    columns[i].visible = true;
                } if (columns[i].binding == "fieldFabric3") {
                    columns[i].visible = true;
                }
            }

        } else if (value == "Material") {
            for (var i = 0; i < columns.length; i++) {
                if (columns[i].binding == "fieldFabric1") {
                    columns[i].visible = false;
                } if (columns[i].binding == "fieldFabric2") {
                    columns[i].visible = false;
                } if (columns[i].binding == "fieldFabric3") {
                    columns[i].visible = false;
                } if (columns[i].binding == "fieldMateria1") {
                    columns[i].visible = true;
                } if (columns[i].binding == "fieldMateria2") {
                    columns[i].visible = true;
                } if (columns[i].binding == "fieldMateria3") {
                    columns[i].visible = true;
                }
            }
        }
    }
    ngAfterViewInit() {
      
        let grid = new wjGrid.FlexGrid(document.createElement('div'));
        grid.initialize({
            autoGenerateColumns:false,            
            itemsSource: this.data,
            columns: [			
                { header: 'SectionList', binding: 'section' },
                { header: 'Header1', binding: 'fieldMateria1', visible: true },
                { header: 'Header2', binding: 'fieldMateria2', visible: true },
                { header: 'Header3', binding: 'fieldMateria3', visible: true} , 				
                { header: 'Country', binding: 'fieldFabric1', visible: false},
                { header: 'Sales', binding: 'fieldFabric2', visible: false},
                { header: 'XYZ', binding: 'fieldFabric3', visible: false}                                           
            ]
        });
        this.flexSheet.sheets.push(new wjSheet.Sheet(this.flexSheet, grid, 'Sheet1'));

        
        for (let i = 0; i < this.flexSheet.rows.length; i++) {
            let row = this.flexSheet.rows[i];
            if (!row.hasChildren) {
                row.isReadOnly = false;
                row.cssClass = 'editable'; // editable class is custom class and defined in styles.css
           }
        }
      
		
			var sheetIndex: number;
			var self=this;				
				self.flexSheet.hostElement.addEventListener('click',function(e){
                    var ht = self.flexSheet.hitTest(e.pageX, e.pageY);
                    var value = self.flexSheet.selectedItems[0] !== undefined ? self.flexSheet.selectedItems[0].section : null; // to avoid error on header click 
						var columns = self.flexSheet.columns;											
                        if (ht.cellType == 1 && value !== "Material"){														 
						for(var i=0;i<columns.length;i++){
								if(columns[i].binding=="fieldMateria1"){
									self.flexSheet.columns[i].visible=false;
								}if(columns[i].binding=="fieldMateria2" ){
									self.flexSheet.columns[i].visible=false;
								}if(columns[i].binding=="fieldMateria3"){
									self.flexSheet.columns[i].visible=false;
								}if(columns[i].binding=="fieldFabric1") {
									self.flexSheet.columns[i].visible=true;
								}if(columns[i].binding=="fieldFabric2"){
									self.flexSheet.columns[i].visible=true;
								}if(columns[i].binding=="fieldFabric3"){
									self.flexSheet.columns[i].visible=true;
								}
							}
							
						}else if(ht.cellType==1 && value == "Material"){						   
							for(var i=0;i<columns.length;i++){
								if(columns[i].binding=="fieldFabric1"){
									self.flexSheet.columns[i].visible=false;
								}if(columns[i].binding=="fieldFabric2" ){
									self.flexSheet.columns[i].visible=false;
								}if(columns[i].binding=="fieldFabric3"){
									self.flexSheet.columns[i].visible=false;
								}if(columns[i].binding=="fieldMateria1") {
									self.flexSheet.columns[i].visible=true;
								}if(columns[i].binding=="fieldMateria2"){
									self.flexSheet.columns[i].visible=true;
								}if(columns[i].binding=="fieldMateria3"){
									self.flexSheet.columns[i].visible=true;
								}
							}
						}
						// check if cell type is rowHeader
						if(ht.cellType==3 && self.flexSheet.selection.row==0){
							
						}
				});
		}							 	
    }

