import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data = [{
        section: "Material", 
		fieldMateria1:"aloo",
		fieldMateria2:"anda",
		fieldMateria3:"gobi",		
        items: [           
            {
                section: "Fabric",               
                items: [
                
                    { fieldFabric1: "India", fieldFabric2: 67, fieldFabric3: "Medium"},
					{ fieldFabric1: "US", fieldFabric2: 45, fieldFabric3: "High"},
					{ fieldFabric1: "UK", fieldFabric2: 78, fieldFabric3: "Low"},  
					{ fieldFabric1: "Japan", fieldFabric2: 34, fieldFabric3: "Low"} 
                ]				
            },
			{
				section: "Trims",
                items: [
                    { fieldFabric1: "India", fieldFabric2: 23435, fieldFabric3: "High"}                   
                ]
			}
            
        ]
    }];
    @ViewChild('flexSheet') flexSheet: wjSheet.FlexSheet; 
    ngAfterViewInit() {
        let grid = new wjGrid.FlexGrid(document.createElement('div'));
        grid.initialize({
            autoGenerateColumns:false,            
            itemsSource: this.data,
            columns: [			
                { header: 'SectionList', binding: 'section' },
				{ header: 'Header1', binding: 'fieldMateria1' },
				{ header: 'Header2', binding: 'fieldMateria2' },
				{ header: 'Header3', binding: 'fieldMateria3' } , 				
				{ header: 'Country', binding: 'fieldFabric1' },
				{ header: 'Sales', binding: 'fieldFabric2' },
				{ header: 'XYZ', binding: 'fieldFabric3' }                                           
            ]
        });
        this.flexSheet.sheets.push(new wjSheet.Sheet(this.flexSheet, grid, 'Sheet1'));
        
        for (let i = 0; i < this.flexSheet.rows.length; i++) {
            let row = this.flexSheet.rows[i];
            if (!row.hasChildren) {
                row.isReadOnly = false;
                row.cssClass = 'editable'; // editable class is custom class and defined in styles.css
           }
            else {
                if (row.dataItem.section == 'Fabric') {
                   // this.flexSheet.setCellData(i, 1, 'Country');
                   // this.flexSheet.setCellData(i, 2, 'Sales/day');
                    //this.flexSheet.setCellData(i, 3, 'XYZ');
                }else if (row.dataItem.section == 'Trims') {
                    //this.flexSheet.setCellData(i, 1, 'CountryTrim');
                    //this.flexSheet.setCellData(i, 2, 'Sales/dayTrim');
                   // this.flexSheet.setCellData(i, 3, 'XYZTrim');
                }
            }
        }
		  
			  if (this.flexSheet) {
			var columns = this.flexSheet.columns;
			for(var i=0;i<columns.length;i++){
								 if(columns[i].binding=="fieldFabric1"){
									 this.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldFabric2" ){
									 this.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldFabric3"){
									 this.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldMateria1") {
									 this.flexSheet.columns[i].visible=true;
								 }if(columns[i].binding=="fieldMateria2"){
									 this.flexSheet.columns[i].visible=true;
								 }if(columns[i].binding=="fieldMateria3"){
									 this.flexSheet.columns[i].visible=true;
								 }
							 }
			 var sheetIndex: number;
			 var self=this;				
					self.flexSheet.hostElement.addEventListener('click',function(e){
						 var ht=  self.flexSheet.hitTest(e.pageX,e.pageY);
						 var value = self.flexSheet.selectedItems[0].section;
						 var columns = self.flexSheet.columns;
						 // check if cell type is cell 
						 /*if(e.srcElement.nextSibling.nodeValue != null){
							   value =  e.srcElement.nextSibling.nodeValue.trim();
						 }else if(e.target.innerText != null){
							   //value =  e.target.innerText.trim();
						 }*/						
						 if(ht.cellType==1 && value == "Fabric"){														 
							for(var i=0;i<columns.length;i++){
								 if(columns[i].binding=="fieldMateria1"){
									 self.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldMateria2" ){
									 self.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldMateria3"){
									 self.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldFabric1") {
									 self.flexSheet.columns[i].visible=true;
								 }if(columns[i].binding=="fieldFabric2"){
									 self.flexSheet.columns[i].visible=true;
								 }if(columns[i].binding=="fieldFabric3"){
									 self.flexSheet.columns[i].visible=true;
								 }
							 }
							
						 }else if(ht.cellType==1 && value == "Material"){
						   
							 for(var i=0;i<columns.length;i++){
								 if(columns[i].binding=="fieldFabric1"){
									 self.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldFabric2" ){
									 self.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldFabric3"){
									 self.flexSheet.columns[i].visible=false;
								 }if(columns[i].binding=="fieldMateria1") {
									 self.flexSheet.columns[i].visible=true;
								 }if(columns[i].binding=="fieldMateria2"){
									 self.flexSheet.columns[i].visible=true;
								 }if(columns[i].binding=="fieldMateria3"){
									 self.flexSheet.columns[i].visible=true;
								 }
							 }
						 }
						 // check if cell type is rowHeader
						 if(ht.cellType==3 && self.flexSheet.selection.row==0){
							
						 }
					});
				}							 	
    }
}
