import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data = [{
        section: "Material", 
		field1:"",
		field2:"",
		field3:"",		
        items: [           
            {
                section: "Fabric",
                items: [
                    { field1: "India", field2: 67, field3: "Medium"},
					{ field1: "US", field2: 45, field3: "High"},
					{ field1: "UK", field2: 78, field3: "Low"},  
					{ field1: "Japan", field2: 34, field3: "Low"} 
                ]				
            },
			{
				section: "Trims",
                items: [
                    { field1: "India", field2: 23435, field3: "High"}                   
                ]
			}
            
        ]
    }];
    @ViewChild('flexSheet') flexSheet: wjSheet.FlexSheet; 
    ngAfterViewInit() {
        let grid = new wjGrid.FlexGrid(document.createElement('div'));
        grid.initialize({
            autoGenerateColumns:false,            
            itemsSource: this.data,
            columns: [			
                { header: 'SectionList', binding: 'section' },
				{ header: 'Header1', binding: 'field1' },
				{ header: 'Header2', binding: 'field2' },
				{ header: 'Header3', binding: 'field3' }                                           
            ]
           

        });
        this.flexSheet.sheets.push(new wjSheet.Sheet(this.flexSheet, grid, 'Sheet1'));
        //console.log(this.flexSheet.sheets[0]); 
    }
}
