var Util;
(function (Util) {
    // generate some random data
    function getCountries() {
        return 'US,Germany,UK,Japan,Italy,Greece'.split(',');
    }
    Util.getCountries = getCountries;
    function getData(count) {
        var countries = getCountries(), data = [];
        for (var i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                date: new Date(2014, i % 12, i % 28),
                amount: Math.random() * 10000,
                active: i % 4 == 0
            });
        }
        return data;
    }
    Util.getData = getData;
    function getTreeData() {
        return [
            {
                header: 'Electronics', img: 'resources/electronics.png', items: [
                    { header: 'Trimmers/Shavers' },
                    { header: 'Tablets' },
                    {
                        header: 'Phones', img: 'resources/phones.png', items: [
                            { header: 'Apple' },
                            { header: 'Motorola' },
                            { header: 'Nokia' },
                            { header: 'Samsung' }
                        ]
                    },
                    { header: 'Speakers' },
                    { header: 'Monitors' }
                ]
            },
            {
                header: 'Toys', img: 'resources/toys.png', items: [
                    { header: 'Shopkins' },
                ]
            },
            {
                header: 'Home', img: 'resources/home.png', items: [
                    { header: 'Coffeee Maker' }
                ]
            }
        ];
    }
    Util.getTreeData = getTreeData;
    function format(value, format) {
        return wijmo.Globalize.format(value, format);
    }
    Util.format = format;
})(Util || (Util = {}));
//# sourceMappingURL=Util.js.map