import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjSheet from 'wijmo/wijmo.grid.sheet';
import * as wjInput from 'wijmo/wijmo.input';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data: wjCore.CollectionView;
    private _dataSvc: DataSvc;
    constructor( @Inject(DataSvc) _dataSvc: DataSvc) {
        this._dataSvc = _dataSvc;
        this.data = new wjCore.CollectionView(_dataSvc.getData(100));
    }
    @ViewChild('flex') flex: wjGrid.FlexGrid;
    changeSource() {
        this.flex.itemsSource = new wjCore.CollectionView(this._dataSvc.getData(5));        
    }
}
