import '../store'
import * as React from 'react'
//import * as wjInput from 'wijmo/wijmo.react.input';
import * as wjGrid from 'wijmo/wijmo.react.grid';
import * as wjChart from 'wijmo/wijmo.chart';
import { DataService } from '../service/DataSvc';
export class App extends React.Component<{}, {}> {
    state = {
        theValue: null,
        theDate: null,
        data: null,
        chartData: null,
    };
    constructor(props) {
        super(props);
        this.state = {
            theValue: 7,
            theDate: new Date(),
            data: DataService.default.getData(100),
            chartData: DataService.default.getChartData(),
        };
       
    }
  
    render() {
       
      
        return <div>
            <h1>Using Wijmo for React external modules in WebPack and SystemJS</h1>
            <p>
                This sample uses external module versions of the Wijmo for React interop,
                and shows how to:
            </p>
            <wjGrid.FlexGrid
                autoGenerateColumns={false}
                columns={[
                    { header: 'Country', binding: 'country', width: '*' },
                    { header: 'Date', binding: 'date' },
                    { header: 'Sales', binding: 'sales', format: 'c2' }
                ]}
                frozenColumns={1}
                itemsSource={this.state.data}
                style={{ height: '250px', width: '500px' }}
            />
            <div id='pie'></div>

        </div>;
    }
    componentDidMount() {
        
        var pie = new wjChart.FlexPie('#pie');
        pie.itemsSource = this.state.chartData;
        pie.bindingName = "name";
        pie.binding = "value";
    }
}
