import { Component ,Inject,ViewChild,ViewContainerRef} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import { MdlDialogService } from "@angular-mdl/core";


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css'],
  viewProviders: [MdlDialogService]
})
export class AppComponent {
    title = 'FlexSheet with multilingual';
    public data: wjCore.CollectionView;
    public data1: wjCore.CollectionView;
    protected dataSvc: DataSvc;
    @ViewChild('parentFlex') flex: wjGrid.FlexGrid;
    constructor( @Inject(DataSvc) dataSvc: DataSvc, private dialogService: MdlDialogService) {
        this.dataSvc = dataSvc;
        this.data = new wjCore.CollectionView(this.dataSvc.getData(20));
        this.data1 = new wjCore.CollectionView(this.dataSvc.getData(20));
    }
    init(flex: wjGrid.FlexGrid, e: wjCore.EventArgs) {
        flex.columns[0].dataMap = new wjGrid.DataMap(this.dataSvc.getCountries(), 'id', 'country');
    }
    onDialogShow() {
        this.flex.invalidate();
    }
    saveUser() {
        
    }
    alertConfirmd() { }
}
