﻿import {
    Component, Inject, Injector, NgModule, ElementRef,
    SkipSelf, Optional, forwardRef, ChangeDetectorRef,
    EventEmitter, OnInit
} from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';
import { FormsModule, NG_VALUE_ACCESSOR } from '@angular/forms';
import { WjValueAccessorFactory } from 'wijmo/wijmo.angular2.directiveBase';

import { WjInputModule, WjInputDate, wjInputDateMeta } from 'wijmo/wijmo.angular2.input';

@Component({
    selector: 'my-date',
    template: wjInputDateMeta.template,
    inputs: wjInputDateMeta.inputs,
    outputs: wjInputDateMeta.outputs,
    providers: [
        { provide: 'WjComponent', useExisting: forwardRef(() => MyInputDate) },
        ...wjInputDateMeta.providers
    ]
})
export class MyInputDate extends WjInputDate implements OnInit {
  
    constructor(private elementRef: ElementRef, injector: Injector, @Inject('WjComponent') @SkipSelf() @Optional() parentCmp: any) {
        super(elementRef, injector, parentCmp);
    }
    
    created() {
        this.isRequired = false;
        this.format = 'MM/dd/yyyy';
        this.mask = '99/99/9999';
        this.min = new Date(-8640000000000000);
        this.max = new Date(8640000000000000);
        this.placeholder = 'mm/dd/yyyy';
    }
  
}




@NgModule({
    imports: [WjInputModule, BrowserModule, FormsModule],
    declarations: [MyInputDate],
    exports: [MyInputDate]
})
export class MyInputDateModule {
}

