import {Component, Inject, ViewChild, OnInit} from '@angular/core';
import {DataSvc} from "../services/DataSvc";
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjCore from "wijmo/wijmo";
import * as wjInput from "wijmo/wijmo.input";
@Component({
    selector: 'app-root',
    templateUrl: './app.component.html',
    styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data: wjCore.CollectionView;
    constructor( @Inject(DataSvc) _dataSvc: DataSvc) {
        this.data = new wjCore.CollectionView(_dataSvc.getCountries());
    }
    @ViewChild('mltiCmplt') mltiCmplt: wjInput.MultiAutoComplete;
    ngAfterViewInit() {
        this.mltiCmplt.hostElement.addEventListener("keydown", (e) => {
            let _inpt = this.mltiCmplt,
                _items = _inpt.collectionView.items,
                _item = _inpt.text;
            if (e.which == 13) {
                // search if text exist in itemsSource or not
                if (_item && !this._searchItem(_items, _item) && _inpt.isEditable) {
                    _inpt.text = "";
                    // if exist, add to selectedItems
                    _inpt.selectedItems.push(_item);
                    // Invalidate control to show newly added selectedItem
                    _inpt.invalidate();                    
                } else {
                    // if item exist, select dropDown first item on Enter key press
                    _inpt.listBox.selectedIndex = 0;
                }
            }
        }, true);
        
    }
    private _searchItem(src: any[], item) {
        for (let i = 0; i < src.length; i++) {
            if (src[i].toLowerCase() == item.toLowerCase()) {
                return true;
            }
        }
        return false;
    }
}
