

import * as wjCore from 'wijmo/wijmo';



'use strict';

import { Injectable } from '@angular/core';
const color = 'Red,Green,Yellow,Blue,Aqua'.split(',');
const customer = 'Alex,Bob,Chris,David'.split(',');
// Common data service
@Injectable()
export class DataSvc {
  
    // data used to generate random items
    getData(count: number) {
        let data = [],
            countries = 'US,UK,Japan,China'.split(',');
        for (let i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                sales: Math.random() * 11111,
                downloads: Math.random()*1455
            });
        }
        return data;
    }
    getCountryMap() {
        let countries = 'US,UK,Japan,China'.split(',');
        let data = [];
        for (let i = 0; i < countries.length; i++) {
            data.push({
                id: i,
                country: countries[i]
            });
        }
        return data;
    }
    getCountries() {
        return 'US,UK,Japan,Italy,China,India,Brazil,Span,Holand,Poland,Canada'.split(',');
    }
    getTestData(count: number) {
        let item1 = {
            temperature: 45,
            functionKey: 'Wijmo',
            passBinSelection: 'FlexGrid',
            retestBinSelection:'wjFlexGridCellTemplate'
        }
        let item2 = {
            temperature: -45,
            functionKey: 'Test functionality',
            passBinSelection: 'Country',
            retestBinSelection: 'Pataya'
        }
        let data = [];
        for (let i = 0; i < count; i++) {
            if (i % 2 == 0) {
                data.push(item1);
            } else {
                data.push(item2);
            }
        }
        return data;
    }
    getTreeData() {
        return  [
            {
                name: 'car', price: 25445, qty: 1, items: [
                    { name: 'wheel', price: 342, qty: 4 },
                    {
                        name: 'engine', price: 1342, qty: 1, items: [
                            { name: 'valve', price: 83, qty: 24 },
                            { name: 'piston', price: 42, qty: 4 },
                        ]
                    },
                    { name: 'seat', price: 542, qty: 4 },
                    { name: 'chassis', price: 4342, qty: 1 }
                ]
            },
            {
                name: 'motorcycle', price: 7543, qty: 1, items: [
                    { name: 'wheel', price: 242, qty: 2 },
                    {
                        name: 'engine', price: 842, qty: 1, items: [
                            { name: 'valve', price: 32, qty: 8 },
                            { name: 'piston', price: 42, qty: 2 },
                        ]
                    },
                    { name: 'seat', price: 142, qty: 1 },
                    { name: 'chassis', price: 742, qty: 1 }
                ]
            },
            {
                name: 'bicycle', price: 543, qty: 1, items: [
                    { name: 'wheel', price: 142, qty: 2 },
                    { name: 'seat', price: 62, qty: 1 },
                    { name: 'chassis', price: 4342, qty: 1 }
                ]
            }
        ];
    }
}

