import { Component ,Inject, ViewChild ,OnInit} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjOlap from 'wijmo/wijmo.olap';
import * as wjInput from 'wijmo/wijmo.input';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']

})
export class AppComponent {
    title = 'WjFlexGrid';
    public data: wjCore.CollectionView;
    @ViewChild('grid') flex: wjGrid.FlexGrid;
    constructor( @Inject(DataSvc) _dataSvc: DataSvc) {
        this.data = new wjCore.CollectionView(_dataSvc.getData(10));
    }
    cols = [{ header: 'Country', binding: 'country' }, { header: 'Id', binding: 'id' }, { header: 'Sales', binding: 'sales' }, {header:' '}];
    saveColumnLayout() {
        if (localStorage) {
            localStorage['columns'] = this.flex.columnLayout;
            console.log('**LAYOUT: ' + this.flex.columnLayout);
        }
    }
    loadColumnLayout() {
        if (localStorage) {
            this.cols = JSON.parse(localStorage['columns']).columns;
            console.log(this.cols);
        }
    }
}
