import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjInput from 'wijmo/wijmo.input';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data: wjCore.CollectionView;
    public countries: any[];
    private _dataSvc: DataSvc;
    constructor( @Inject(DataSvc) _dataSvc: DataSvc) {
        this._dataSvc = _dataSvc;        
        this.countries = this._dataSvc.getCountries();   
        this.data= new wjCore.CollectionView(this._dataSvc.getData(15));     
    }
    
    initGrid(s: wjGrid.FlexGrid, e: wjCore.EventArgs) {              
        this._createEditor(s.columns.getColumn('country'));
        this._createEditor(s.columns.getColumn("date"));
      
    }
    _createEditor(editColumn) {
        var grid = editColumn.grid;
        grid.formatItem.addHandler( (s, e)=> {
            var editRange = grid.editRange,
                column = e.panel.columns[e.col];
            // check whether this is an editing cell of the wanted column
            if ((e.panel.cellType == wjGrid.CellType.Cell && editRange && column == editColumn && editColumn.index == e.col && editRange.row == e.row && editRange.col == e.col)) {
                if (e.cell.firstChild) {
                    e.cell.firstChild.style.display = 'none';
                }
                var editRoot = document.createElement('div');
                let inpt;
                if(column.dataType==wjCore.DataType.String){
                    inpt = new wjInput.ComboBox(editRoot);
                    inpt.itemsSource = this.countries;
                    inpt.selectedValue = grid.getCellData(e.row, e.col);
                    inpt.displayMemberPath = 'country';
                    inpt.selectedValuePath = 'country';
                }
                if(column.dataType==wjCore.DataType.Date){
                    inpt= new wjInput.InputDate(editRoot);
                    inpt.value = grid.getCellData(e.row, e.col);
                }
                e.cell.appendChild(editRoot);
                inpt.focus();
                // cellEditEnding that updates cell with user's input
                var editEndingEH = function (s, args) {
                    grid.cellEditEnding.removeHandler(editEndingEH);
                    if (!args.cancel) {
                        args.cancel = true;
                        if(column.dataType==wjCore.DataType.String){
                            grid.setCellData(args.row, args.col, inpt.selectedValue);
                        }
                        if(column.dataType==wjCore.DataType.Date){
                            grid.setCellData(args.row, args.col, inpt.value);
                        }
                    }
                };
                // subscribe the handler to the cellEditEnding event
                grid.cellEditEnding.addHandler(editEndingEH);
            }

        });

    }
}
