﻿'use strict';

import { Injectable } from '@angular/core';
import * as wjCore from 'wijmo/wijmo';
// Common data service
@Injectable()
export class DataSvc {

    // get data for grid
    // data used to generate random items
    getData(count: number): wjCore.ObservableArray {
        let data = new wjCore.ObservableArray(),
            countries = 'US,UK,Japan,China'.split(',');
        for (let i = 0; i < count; i++) {
            data.push({
                id: i,
                country: countries[i % countries.length],
                sales: Math.random() * 100000
            });
        }
        return data;
    }
    getCountry() {
        return 'US,Germany,UK,Japan,Italy,Greece'.split(',');
    }
    getItemsSource() {
        var data = [
            { "id": 0, "country": {"name":'US' , 'continent':'America'}, "date": "2013-12-30T22:00:00.000Z", "amount": 2499.0972157351976, "active": true },
            { "id": 1, "country": { "name":'Germany', 'continent':'Europe'}, "date": "2014-01-31T22:00:00.000Z", "amount": 1986.8828015541994, "active": false },
            { "id": 2, "country": { "name": 'UK', 'continent': 'Europe' }, "date": "2014-03-01T22:00:00.000Z", "amount": 307.00672290479014, "active": false }
        ];
        return data;
    }
}
