import { Component ,Inject,ViewChild} from '@angular/core';
import { DataSvc } from '../services/DataSvc';

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';
import * as wjInput from 'wijmo/wijmo.input';


@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
    public data: wjCore.CollectionView;
    public countries: any[];
    private _dataSvc: DataSvc;
    public child;
    constructor( @Inject(DataSvc) _dataSvc: DataSvc) {
        this._dataSvc = _dataSvc;
        this.countries = this._dataSvc.getCountries();
        this.data= new wjCore.CollectionView(this._dataSvc.getTreeData());
        this.child= this._dataSvc.getChild();
    }
    @ViewChild('flex') flex:wjGrid.FlexGrid;
    
    initGrid(s, e) {
        for(let i=0;i<s.rows.length;i++){
            s.rows[i].isReadOnly=true;
        }
    }
   
    change(){
        this.flex.setCellData(3,0,"Spacetronic Eyes");
        console.log(this.data.currentItem);
    }
}
