import { Component,ViewChild } from '@angular/core';
import { NavController, NavParams, Platform } from 'ionic-angular';
import { LoadingController } from 'ionic-angular';
import { HomeProvider } from './home.provider'

import * as wjCore from 'wijmo/wijmo';
import * as wjGrid from 'wijmo/wijmo.grid';

@Component({
  selector: 'page-home',
  templateUrl: 'home.html'
})
export class HomePage {
  @ViewChild('flex') flex: wjGrid.FlexGrid;

  dataCollection: wjCore.CollectionView;
  errorMessage: string;


  constructor(
    public navCtrl: NavController,
    public navParams: NavParams,
    public plt: Platform,
    public loadingCtrl: LoadingController,
    public homeProvider: HomeProvider
  ) {
  }

  ionViewDidLoad() {
    this.getData();
  }

  getData() {
      this.homeProvider.getData('../assets/data/home.json').subscribe((jsonData) => {
        this.dataCollection = new wjCore.CollectionView(jsonData);
      },
        error => this.errorMessage = <any>error
      );
  }

  isDate(val): boolean {
    let date = new Date(val);

    return !isNaN(date.valueOf());
  }

  initFlex(s: wjGrid.FlexGrid): void {   
    s.allowMerging = wjGrid.AllowMerging.All;
    s.columnHeaders.rows.push(new wjGrid.Row());
    s.columnHeaders.rows.push(new wjGrid.Row());
    s.columnHeaders.rows.push(new wjGrid.Row());       
    s.columnHeaders.rows[3].wordWrap = true;
    s.columnHeaders.rows[0].allowMerging = true;
    s.columnHeaders.rows[1].allowMerging = true;
    s.columnHeaders.rows[2].allowMerging = true;
    // since first two columns are hide, we need to provide range 0,2 t0 2,8
    
  }
  // to apply custom Merging if you know CellRange; 
  // This will lost defaule merging
  //  private _mergeHeaders(grid:wjGrid.FlexGrid,range:wjGrid.CellRange):void{
  //   let mm= new wjGrid.MergeManager(grid);    
  //   mm.getMergedRange = function(panel, r, c) {
  //       if (panel.cellType == wjGrid.CellType.ColumnHeader) {
  //           if (r >= 0 && range.contains(r, c)) {              
  //               return range;
  //           }
  //       }
  //       return null;
  //   };
  //   grid.mergeManager=mm;
  // }
  changeColumnHeader(s: wjGrid.FlexGrid): void {
    for (let i = 0; i < s.columns.length; i++) {
      let colHeader: string = s.columnHeaders.columns[i].header;

      if (colHeader === 'Team Member Leader') {
        s.columnHeaders.columns[i].header = 'Team Leader';
      } else if (colHeader === 'Team Member Name') {
        s.columnHeaders.columns[i].header = 'Member Name';
      } else if (colHeader === 'Trade Category') {
        s.columnHeaders.columns[i].header = 'Trade';
      } else if (colHeader === 'Trade Sub Category') {
        s.columnHeaders.columns[i].header = 'Sub Category';
      }
    }
  }

  setColumnWidth(s: wjGrid.FlexGrid, i: number): void {
    if (s.columns[i].name === 'tradeCategory') {
      s.columns[i].width = 80;
    } else if (s.columns[i].name === 'tdOrTemp') {
      s.columns[i].width = 80;
    } else if (s.columns[i].name === 'tempCompany') {
      s.columns[i].width = 80;
    }
  }

  initHideColumns(s: wjGrid.FlexGrid): void {
    if (s.rows.length > 0) {
      let mustHide: string = 'teamMemberID, businessUnitID';
      let splitCol: Array < string > = mustHide ? mustHide.split(',') : [];

        for (let i = 0; i < splitCol.length; i++) {
          s.columns[s.getColumn(splitCol[i].trim()).index].visible = false;
        }
    }
  }

  loadedRows(s: wjGrid.FlexGrid): void {
    if (s.columns.length > 0) {
      this.initHideColumns(s);
      this.changeColumnHeader(s);

      for (let c = 0; c < s.columns.length; c++) {
        s.columns[c].isRequired = false;
        if (this.isDate(s.columns[c].name) === true) {
          for (let r = 0; r < s.rows.length; r++) {
            if (s.getCellData(r, c, false) === '') {
              s.setCellData(r, c, null, false, false);
            }
          }
        }
      }

      let dateSet: boolean = false;

      for (let i = 0; i < s.columns.length; i++) {
        if (this.isDate(s.columns[i].name) === true) {
          let dateTemp = new Date(s.columns[i].name);

          if (dateSet === false) {
            let firstDate: number = i;

            for (let j = firstDate; j < firstDate + 7; j++) {
              s.columnHeaders.setCellData(0, j, 'Reference Only', false, false);
              s.columnHeaders.setCellData(0, j + 7, 'Current Week', false, false);

              s.columnHeaders.setCellData(1, j, s.columns[firstDate + 2].name, false, false);
              s.columnHeaders.setCellData(1, j + 7, s.columns[firstDate + 9].name, false, false);
            }

            dateSet = true;
          }

          s.columnHeaders.setCellData(2, i, dateTemp.toString().substring(0, 3), false, false);
          s.columns[i].aggregate = 'Cnt';
          s.columns[i].width = 60;
          s.columns[i].align = 'center';

        } else {
          this.setColumnWidth(s, i);
        }
      }

      for (let i = 0; i < s.rows.length; i++) {
        if (s.rows[i].hasChildren !== undefined) {
          let level: number = s.rows[i].level;

          if (level >= 0) {
            if (level > 2) {
              level = 2;
            }

            s.rows[i].cssClass = 'level' + level;
          }
        }
      }

      for (let i = 0; i < s.rows.length; i++) {
        s.rows[i].allowMerging = true;
      }

      if (s.rows.length > 0) {
        for (let i = 0; i < 4; i++) {
          s.autoSizeRow(i, true);
        }
      }
    }
    //this._mergeHeaders(s, new wjGrid.CellRange(0,2,2,8)); 
  }

  formatItem(s: wjGrid.FlexGrid, e: wjGrid.FormatItemEventArgs): void {
    if (wjGrid.CellType.Cell === e.panel.cellType ) {
      let color="";
      // change background color for merged range
      if(s.getMergedRange(e.panel,e.row,e.col)){
        color='rgb(12, 228, 88)';
      }
      if (e.row === 0) {
        color = 'aqua';
      } else if (e.row === 2) {
        e.panel.rows[e.row].cssClass= 'my';
      } else if (e.col === 3) {
        color = 'lightgrey';
      } else if (e.col === 4) {
        color = 'lightblue';
      }
      // to avoid set background color for inappropriate cells on scrolling
      e.cell.style.backgroundColor=color;
    }
  }
}
